/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm;

import de.dietzm.Constants;
import de.dietzm.Layer;
import de.dietzm.Model;
import de.dietzm.gcodes.GCode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class GCodeUtil {
    public static final String VERSION = "0.99";

    public static void main(String[] args) {
        if (args.length < 2) {
            GCodeUtil.printUsageandExit();
        }
        String mode = args[0];
        String filename = args[1];
        if (mode.startsWith("e")) {
            if (args.length < 4) {
                GCodeUtil.printUsageandExit();
            }
            filename = args[3];
        }
        if (!new File(filename).exists()) {
            GCodeUtil.printUsageandExit();
        }
        try {
            long start = System.currentTimeMillis();
            Model model = new Model(filename);
            model.loadModel();
            long load = System.currentTimeMillis();
            model.analyze();
            if (mode.startsWith("e")) {
                String option = args[1];
                String layersarg = args[2];
                Collection<Layer> lays = GCodeUtil.parseLayerArgument(model, layersarg);
                if (option.contains("offset=") && !layersarg.equalsIgnoreCase("all")) {
                    System.err.println("Offset change can only be done if all layers are choosen");
                    System.exit(1);
                }
                GCodeUtil.editLayer(model, option, lays);
            }
            if (mode.contains("m")) {
                GCodeUtil.printModelDetails(model);
            }
            if (mode.contains("l")) {
                GCodeUtil.printLayerSummary(model);
            }
            if (mode.contains("s")) {
                GCodeUtil.printModelSpeedDetails(model);
            }
            if (mode.matches(".*[pn].*")) {
                GCodeUtil.printLayerDetails(model, mode);
            }
            if (mode.contains("c")) {
                GCodeUtil.printComments(model);
            }
            if (mode.contains("g")) {
                GCodeUtil.printGCodeDetails(model, mode);
            }
            if (mode.contains("x")) {
                GCodeUtil.printGCodeDetailsCSV(model, mode);
            }
            long end = System.currentTimeMillis();
            System.out.println("Gcode Analyse Time: " + Constants.formatTimetoHHMMSS((float)(end - start) / 1000.0f, null) + " Load time:" + Constants.formatTimetoHHMMSS((float)(load - start) / 1000.0f, null));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void editLayer(Model model, String option, Collection<Layer> lays) throws IOException {
        if (option.startsWith("speed=")) {
            int value = Integer.parseInt(option.substring(6));
            Model.changeSpeed(lays, value);
        } else if (option.startsWith("extr=")) {
            int value = Integer.parseInt(option.substring(5));
            Model.changeExtrusion(lays, value);
        } else if (option.startsWith("exttemp=")) {
            float value = Float.parseFloat(option.substring(8));
            Model.changeExtTemp(lays, value);
        } else if (option.startsWith("bedtemp=")) {
            float value = Float.parseFloat(option.substring(8));
            Model.changeBedTemp(lays, value);
        } else if (option.startsWith("layerh=")) {
            int value = Integer.parseInt(option.substring(7));
            Model.changeLayerHeight(lays, value);
        } else if (option.startsWith("zoffset=")) {
            float value = Float.parseFloat(option.substring(8));
            Model.changeZOffset(lays, value);
        } else if (option.startsWith("yoffset=")) {
            float value = Float.parseFloat(option.substring(8));
            Model.changeYOffset(lays, value);
        } else if (option.startsWith("xoffset=")) {
            float value = Float.parseFloat(option.substring(8));
            Model.changeXOffset(lays, value);
        } else if (option.startsWith("fan=")) {
            int value = Integer.parseInt(option.substring(4));
            System.out.println("Change Fan to " + value);
            Model.changeFan(lays, value);
        } else if (option.startsWith("delete")) {
            System.out.println("Delete Layers ");
            Model.deleteLayer(lays);
        } else {
            GCodeUtil.printUsageandExit();
        }
        System.out.println("Saving to file " + model.getFilename() + "-new");
        model.saveModel(String.valueOf(model.getFilename()) + "-new");
        System.exit(0);
    }

    private static Collection<Layer> parseLayerArgument(Model model, String layersarg) {
        ArrayList<Layer> lays;
        if (layersarg.equalsIgnoreCase("all")) {
            lays = model.getLayer();
        } else {
            String[] layersarg1 = layersarg.split(",");
            lays = new ArrayList();
            for (Layer lay1 : model.getLayer()) {
                String[] stringArray = layersarg1;
                int n = layersarg1.length;
                int n2 = 0;
                while (n2 < n) {
                    String lan = stringArray[n2];
                    if (lan.equals(String.valueOf(lay1.getNumber()))) {
                        lays.add(lay1);
                    }
                    ++n2;
                }
            }
        }
        if (lays.isEmpty()) {
            System.err.println("No matching layers found.");
            System.exit(1);
        }
        return lays;
    }

    private static void printUsageandExit() {
        String name = "GcodeUtil";
        System.err.println(String.valueOf(name) + " " + VERSION + "\nWrong Parameters or gcode file does not exist.");
        System.err.println("Usage: " + name + " [mode m|l|p|n] gcodefile ");
        System.err.println("Modes:");
        System.err.println("\tm = Show Model Info");
        System.err.println("\tl = Show Layer Summary");
        System.err.println("\tp = Show Printed Layer Detail Info");
        System.err.println("\tn = Show Non-Printed Layer Detail Info");
        System.err.println("\ts = Show Printing Speed Details Info");
        System.err.println("\tc = Show embedded comments (e.g. from slicer)");
        System.err.println("\tx = Print Gcode details as CSV output");
        System.err.println("Edit Mode Usage: " + name + " [editmode e] [option] [layers]  gcodefile ");
        System.err.println("\te speed=-10 = Reduce Speed by 10 percent");
        System.err.println("\te extr=10 = Increase extrusion rate by 10 percent");
        System.err.println("\te layerh=10 = Increase Layerheight by 10 percent (+increase extrusion)");
        System.err.println("\te exttemp=170.3 = Set extruder temperatur to 170.3 (only update existing gcodes)");
        System.err.println("\te bedtemp=50.3 = Set bed temperatur to 50.3 (only update existing gcodes)");
        System.err.println("\te zoffset=0.1 = Add Offset to Z position (requires layer option 'all'");
        System.err.println("\te xoffset=0.1 = Add Offset to X position (requires layer option 'all'");
        System.err.println("\te yoffset=0.1 = Add Offset to Y position (requires layer option 'all'");
        System.err.println("\te fan=255 = Set Fan 0=off, 255=full (only update existing gcodes)");
        System.err.println("\te delete = Delete the specified layers");
        System.err.println("[layers] = comma separated list of layers or 'all' for all ");
        System.err.println("\nExample: \nShow Model Info and Printed Layers");
        System.err.println("\t " + name + " mp /tmp/object.gcode ");
        System.err.println("\nShow All Info");
        System.err.println("\t " + name + " mlpnsc /tmp/object.gcode ");
        System.err.println("\nEdit Model, increase 1-3 layer speed by 25%");
        System.err.println("\t " + name + " e speed=25 1,2,3 /tmp/object.gcode ");
        System.err.println("\nEdit Model, disable fan for all layers");
        System.err.println("\t " + name + " e fan=0 all /tmp/object.gcode ");
        System.exit(1);
    }

    private static void printComments(Model model) {
        System.out.println("***************************************************************************");
        System.out.println("****************************** Embedded Comments **************************");
        System.out.println("***************************************************************************");
        System.out.println(model.getModelComments());
    }

    private static void printModelDetails(Model model) {
        System.out.println("***************************************************************************");
        System.out.println("****************************** Model Details ******************************");
        System.out.println("***************************************************************************");
        System.out.println(String.valueOf(model.getModelDetailReport()) + model.guessPrice(model.guessDiameter()));
    }

    private static void printModelSpeedDetails(Model model) {
        System.out.println(model.getModelSpeedReport());
    }

    private static void printLayerSummary(Model model) {
        System.out.println(model.getModelLayerSummaryReport());
    }

    private static void printLayerDetails(Model model, String mode) {
        System.out.println("***************************************************************************");
        System.out.println("****************************** Layer Details ******************************");
        System.out.println("***************************************************************************");
        ArrayList<Layer> layers = new ArrayList<Layer>(model.getLayer());
        for (Layer lay : layers) {
            float layperc = Constants.round2digits(lay.getTime() / (model.getTime() / 100.0f));
            if (lay.isPrinted() && mode.contains("p")) {
                System.out.println("--------------------------------------------------");
                System.out.println(String.valueOf(lay.getLayerDetailReport()) + "\n Percent of time:" + layperc + "%");
                if (!mode.contains("s")) continue;
                System.out.println(lay.getLayerSpeedReport());
                continue;
            }
            if (lay.isPrinted() || !mode.contains("n")) continue;
            System.out.println("--------------------------------------------------");
            System.out.println(String.valueOf(lay.getLayerDetailReport()) + "\n Percent of time:" + layperc + "%");
            if (!mode.contains("s")) continue;
            System.out.println(lay.getLayerSpeedReport());
        }
    }

    private static void printGCodeDetails(Model model, String mode) {
        System.out.println("***************************************************************************");
        System.out.println("****************************** GCODE Details ******************************");
        System.out.println("***************************************************************************");
        ArrayList<Layer> layers = new ArrayList<Layer>(model.getLayer());
        for (Layer lay : layers) {
            float layperc = Constants.round2digits(lay.getTime() / (model.getTime() / 100.0f));
            if (!lay.isPrinted()) continue;
            System.out.println("--------------------------------------------------");
            System.out.println(String.valueOf(lay.getLayerDetailReport()) + "\n Percent of time:" + layperc + "%");
            for (GCode gc : lay.getGcodes()) {
                System.out.println("\t" + gc.toString());
            }
        }
    }

    private static void printGCodeDetailsCSV(Model model, String mode) {
        System.out.println("***************************************************************************");
        System.out.println("****************************** GCODE Details ******************************");
        System.out.println("***************************************************************************");
        ArrayList<Layer> layers = new ArrayList<Layer>(model.getLayer());
        System.out.println("Layer;Speed;Extrusion;Distance;Time;Fanspeed");
        for (Layer lay : layers) {
            for (GCode gc : lay.getGcodes()) {
                System.out.println(String.valueOf(lay.getNumber()) + ";" + gc.toCSV());
            }
        }
    }
}

