/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodes;

import de.dietzm.Constants;
import de.dietzm.Position;
import de.dietzm.gcodes.GCode;

public class GCodeXY
extends GCode {
    private float x = Float.MAX_VALUE;
    private float y = Float.MAX_VALUE;
    private float time;
    private float timeaccel;
    private float distance;
    private short fanspeed;

    public GCodeXY(String line, int linenr, Constants.GCDEF code) {
        super(line, linenr, code);
    }

    @Override
    public void setInitialized(short mask, float value) {
        switch (mask) {
            case 4: {
                this.x = value;
                break;
            }
            case 8: {
                this.y = value;
                break;
            }
        }
    }

    @Override
    public String toCSV() {
        String var = String.valueOf(this.getSpeed());
        var = String.valueOf(var) + ";" + this.distance;
        var = String.valueOf(var) + ";" + this.time;
        var = String.valueOf(var) + ";" + this.fanspeed;
        return var;
    }

    @Override
    public String toString() {
        String var = String.valueOf(this.lineindex) + ":  " + this.toStringRaw();
        var = String.valueOf(var) + "\tExtrusion:0";
        var = String.valueOf(var) + "\tDistance:" + this.distance;
        var = String.valueOf(var) + "\tPosition:" + this.x + "x" + this.y;
        var = String.valueOf(var) + "\tTime:" + this.time;
        return var;
    }

    @Override
    public float getS_Fan() {
        return 0.0f;
    }

    @Override
    public float getF() {
        return 0.0f;
    }

    @Override
    public float getS_Ext() {
        return 0.0f;
    }

    @Override
    public Position getCurrentPosition(Position pos) {
        pos.x = this.x;
        pos.y = this.y;
        return pos;
    }

    @Override
    public float getS_Bed() {
        return 0.0f;
    }

    @Override
    public float getBedtemp() {
        return 0.0f;
    }

    @Override
    public float getExtemp() {
        return 0.0f;
    }

    @Override
    protected void setUnit(String unit) {
    }

    @Override
    public float getDistance() {
        return this.distance;
    }

    @Override
    public float getE() {
        return 0.0f;
    }

    @Override
    public float getExtrusion() {
        return 0.0f;
    }

    @Override
    public float getExtrusionSpeed() {
        return 0.0f;
    }

    @Override
    public short getFanspeed() {
        return this.fanspeed;
    }

    @Override
    public Position getPosition(Position reference) {
        return new Position(this.isInitialized(4) ? this.x : reference.x, this.isInitialized(8) ? this.y : reference.y);
    }

    @Override
    public float getSpeed() {
        return Constants.round2digits(this.distance / this.time);
    }

    @Override
    public float getTime() {
        return this.time;
    }

    @Override
    public float getTimeAccel() {
        return this.timeaccel;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public boolean isExtrudeOrRetract() {
        return false;
    }

    @Override
    public boolean isExtruding() {
        return false;
    }

    @Override
    public boolean isInitialized(int mask) {
        switch (mask) {
            case 4: {
                return this.x != Float.MAX_VALUE;
            }
            case 8: {
                return this.y != Float.MAX_VALUE;
            }
        }
        return false;
    }

    @Override
    public void setCurrentPosition(Position currentPosition) {
        this.x = currentPosition.x;
        this.y = currentPosition.y;
    }

    @Override
    public void setDistance(float distance) {
        this.distance = distance;
    }

    @Override
    public void setExtrusion(float extrusion) {
    }

    @Override
    public void setFanspeed(float fanspeed) {
        this.fanspeed = (short)fanspeed;
    }

    @Override
    public void setTime(float time) {
        this.time = time;
    }

    @Override
    public void setTimeAccel(float time) {
        this.timeaccel = time;
    }

    @Override
    public float getZ() {
        return 0.0f;
    }

    @Override
    public float getR() {
        return 0.0f;
    }

    @Override
    public float getKz() {
        return 0.0f;
    }

    @Override
    public float getJy() {
        return 0.0f;
    }

    @Override
    public float getIx() {
        return 0.0f;
    }

    @Override
    public String getUnit() {
        return null;
    }
}

