/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.print;

import de.dietzm.gcodes.MemoryEfficientString;
import java.nio.ByteBuffer;

public class ReceiveBuffer
implements CharSequence {
    public byte[] array;
    int offset;
    int len;
    boolean timedout = false;

    protected boolean isTimedout() {
        return this.timedout;
    }

    protected void setTimedout(boolean timedout) {
        this.timedout = timedout;
    }

    public ReceiveBuffer(int size) {
        this.array = new byte[size];
        this.offset = 0;
        this.len = 0;
    }

    public void put(ByteBuffer buf) {
        if (buf.position() > this.array.length) {
            throw new IndexOutOfBoundsException("ReceiveBuffer size exceeded");
        }
        System.arraycopy(buf.array(), 0, this.array, 0, buf.position());
        this.len = buf.position();
    }

    public void put(byte[] buf) {
        if (buf.length > this.array.length) {
            throw new IndexOutOfBoundsException("ReceiveBuffer size exceeded");
        }
        System.arraycopy(buf, 0, this.array, 0, buf.length);
        this.len = buf.length;
    }

    public void append(ByteBuffer buf) {
        if (this.len + buf.position() > this.array.length) {
            throw new IndexOutOfBoundsException("ReceiveBuffer size exceeded");
        }
        System.arraycopy(buf.array(), 0, this.array, this.len, buf.position());
        this.len += buf.position();
    }

    public void clear() {
        this.len = 0;
        this.timedout = false;
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean endsWithNewLine() {
        if (this.len == 0) {
            return false;
        }
        return this.array[this.len - 1] == 10;
    }

    public boolean startsWithOK() {
        if (this.len < 2) {
            return false;
        }
        return this.array[0] == 111 && this.array[1] == 107;
    }

    public boolean startsWithGO() {
        if (this.len < 2) {
            return false;
        }
        return this.array[0] == 103 && this.array[1] == 111;
    }

    public boolean containsOK() {
        if (this.len < 2) {
            return false;
        }
        int i = 0;
        while (i < this.len - 1) {
            if (this.array[i] == 111 && this.array[i + 1] == 107) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(char ch) {
        if (this.len < 1) {
            return -1;
        }
        int i = 0;
        while (i < this.len - 1) {
            if (this.array[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(char ch, int start) {
        if (this.len < 1) {
            return -1;
        }
        int i = start;
        while (i < this.len - 1) {
            if (this.array[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean containsWait() {
        if (this.len < 4) {
            return false;
        }
        int i = 0;
        while (i < this.len - 3) {
            if (this.array[i] == 119 && this.array[i + 1] == 97 && this.array[i + 2] == 105 && this.array[i + 3] == 116) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsFail() {
        if (this.len < 4) {
            return false;
        }
        int i = 0;
        while (i < this.len - 3) {
            if (this.array[i] == 102 && this.array[i + 1] == 97 && this.array[i + 2] == 105 && this.array[i + 3] == 108) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean startsWithSD() {
        if (this.len < 2) {
            return false;
        }
        return this.array[0] == 83 && this.array[1] == 68;
    }

    public int parseSDStatus() {
        if (this.len < 17) {
            return 0;
        }
        int sdtext = 17;
        if (this.startsWithSD()) {
            int idx2;
            int done;
            int idx;
            block8: {
                idx = this.indexOf('/');
                if (idx == -1) {
                    return 0;
                }
                try {
                    done = Integer.parseInt(this.subSequence(sdtext, idx).toString());
                    idx2 = this.indexOf('\n', idx + 1);
                    if (idx2 != -1) break block8;
                    return 0;
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            String remain = this.subSequence(idx + 1, idx2).toString();
            int total = Integer.parseInt(remain);
            if (total == 0 || total / 100 == 0) {
                return 100;
            }
            if (done == 0) {
                return 0;
            }
            return done / (total / 100);
        }
        return 0;
    }

    public boolean startsWithEcho() {
        if (this.len < 4) {
            return false;
        }
        return this.array[0] == 101 && this.array[1] == 99 && this.array[2] == 104 && this.array[3] == 111;
    }

    public boolean isPlainOK() {
        return this.len == 3 && this.startsWithOK() && this.endsWithNewLine();
    }

    @Override
    public String toString() {
        return new String(this.array, 0, this.len);
    }

    public boolean containsTx() {
        if (this.len < 2) {
            return false;
        }
        int i = 0;
        while (i < this.len - 1) {
            if (this.array[i] == 84 && this.array[i + 1] == 58) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public char charAt(int index) {
        return (char)this.array[index];
    }

    @Override
    public int length() {
        return this.len;
    }

    public void setlength(int newlen) {
        this.len = newlen;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end > this.len) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.length());
        }
        byte[] newdata = new byte[end - start];
        System.arraycopy(this.array, start, newdata, 0, end - start);
        return new MemoryEfficientString(newdata);
    }

    public MemoryEfficientString subSequence(int start, int end, MemoryEfficientString str) {
        if (start < 0 || end > this.len) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.length());
        }
        byte[] newdata = str.getBytes();
        int len = Math.min(end - start, str.length());
        System.arraycopy(this.array, start, newdata, 0, len);
        str.clear(len);
        return str;
    }
}

