/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm;

import de.dietzm.Constants;
import de.dietzm.GCodeMod;
import de.dietzm.Layer;
import de.dietzm.Position;
import de.dietzm.SpeedEntry;
import de.dietzm.gcodes.GCode;
import de.dietzm.gcodes.GCodeFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class Model {
    private static double PRICE_PER_G = 0.03;
    private boolean isguessed = false;
    private static boolean ACCELERATION = true;
    private float avgbedtemp = 0.0f;
    private float avgextemp = 0.0f;
    private float avgLayerHeight = 0.0f;
    private float avgspeed = 0.0f;
    private float avgtravelspeed = 0.0f;
    private float maxprintspeed = 0.0f;
    private float minprintspeed = Float.MAX_VALUE;
    private float[] boundaries = new float[]{0.0f, 9999.0f, 0.0f, 9999.0f, 0.0f};
    private float[] dimension = new float[]{0.0f, 0.0f, 0.0f};
    private float extrusion = 0.0f;
    private String filename;
    private ArrayList<GCode> gcodes = new ArrayList(1000000);
    private ArrayList<Layer> layer = new ArrayList();
    private int layercount = 0;
    private int notprintedLayers = 0;
    private SortedMap<Float, SpeedEntry> SpeedAnalysisT = new TreeMap<Float, SpeedEntry>();
    private float time;
    private float distance;
    private float traveldistance;
    private float timeaccel;
    private String unit = "mm";
    private long filesize = 0L;
    private long readbytes = 0L;

    public long getFilesize() {
        return this.filesize;
    }

    public long getReadbytes() {
        return this.readbytes;
    }

    public Model(String file) {
        this.filename = file;
        try {
            String kgprice = System.getenv("FILAMENT_PRICE_KG");
            if (kgprice != null) {
                PRICE_PER_G = Float.parseFloat(kgprice) / 1000.0f;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Model(String file, ArrayList<GCode> gcall) {
        this(file);
        this.gcodes = gcall;
    }

    public void analyze() {
        float f_old;
        Layer currLayer;
        Layer lastprinted = currLayer = this.startLayer(0.0f, null);
        float xpos = 0.0f;
        float lastxpos = 0.0f;
        float lastypos = 0.0f;
        float lastzpos = 0.0f;
        boolean pos_changed = false;
        float ypos = 0.0f;
        float zpos = 0.0f;
        float epos = 0.0f;
        float f_new = f_old = 1000.0f;
        float bedtemp = 0.0f;
        float extemp = 0.0f;
        for (GCode gc : this.getGcodes()) {
            lastxpos = xpos;
            lastypos = ypos;
            lastzpos = zpos;
            if (gc.getGcode() == Constants.GCDEF.G28 || gc.getGcode() == Constants.GCDEF.G92) {
                if (gc.isInitialized(1)) {
                    epos = gc.getE();
                }
                if (gc.isInitialized(4)) {
                    xpos = gc.getX();
                }
                if (gc.isInitialized(8)) {
                    ypos = gc.getY();
                }
                if (gc.isInitialized(16)) {
                    zpos = gc.getZ();
                }
            }
            if (gc.isInitialized(2)) {
                if (!gc.isInitialized(4) && !gc.isInitialized(8) && !gc.isInitialized(16) || !ACCELERATION) {
                    f_old = gc.getF();
                    f_new = gc.getF();
                } else {
                    f_new = gc.getF();
                }
            }
            if (gc.getGcode() == Constants.GCDEF.G1 || gc.getGcode() == Constants.GCDEF.G0 || gc.getGcode() == Constants.GCDEF.G2 || gc.getGcode() == Constants.GCDEF.G3) {
                if (currLayer.getGcodes().size() < 5) {
                    currLayer.setBedtemp(bedtemp);
                    currLayer.setExttemp(extemp);
                }
                if (gc.isInitialized(16) && gc.getZ() != currLayer.getZPosition()) {
                    if (currLayer.isPrinted()) {
                        lastprinted = currLayer;
                    } else if (lastprinted != currLayer) {
                        for (GCode gco : currLayer.getGcodes()) {
                            lastprinted.addGcodes(gco);
                        }
                        --this.layercount;
                        this.layer.remove(currLayer);
                    }
                    currLayer = this.startLayer(gc.getZ(), lastprinted);
                    currLayer.setBedtemp(bedtemp);
                    currLayer.setExttemp(extemp);
                }
                float move = 0.0f;
                if (gc.getGcode() == Constants.GCDEF.G2 || gc.getGcode() == Constants.GCDEF.G3) {
                    double angle2;
                    double angle1;
                    float cx = xpos + gc.getIx();
                    float cy = ypos + gc.getJy();
                    float newxpos = gc.isInitialized(4) ? gc.getX() : xpos;
                    float newypos = gc.isInitialized(8) ? gc.getY() : ypos;
                    float bx = newxpos - cx;
                    float by = newypos - cy;
                    float ax = xpos - cx;
                    float ay = ypos - cy;
                    float xmove = Math.abs(cx - xpos);
                    float ymove = Math.abs(cy - ypos);
                    float radius = (float)Math.sqrt(xmove * xmove + ymove * ymove);
                    if (gc.getGcode() == Constants.GCDEF.G2) {
                        angle1 = Math.atan2(by, bx) * 57.29577951308232;
                        angle2 = Math.atan2(ay, ax) * 57.29577951308232;
                    } else {
                        angle2 = Math.atan2(by, bx) * 57.29577951308232;
                        angle1 = Math.atan2(ay, ax) * 57.29577951308232;
                    }
                    double angle = (int)(angle2 - angle1);
                    xpos = newxpos;
                    ypos = newypos;
                    move = (float)(Math.PI * (double)radius * angle / 180.0);
                    gc.setDistance(move);
                } else if (gc.isInitialized(4) && gc.isInitialized(8)) {
                    float ymove;
                    float xmove = Math.abs(xpos - gc.getX());
                    if (xmove + (ymove = Math.abs(ypos - gc.getY())) == 0.0f) continue;
                    xpos = gc.getX();
                    ypos = gc.getY();
                    move = (float)Math.sqrt(xmove * xmove + ymove * ymove);
                    gc.setDistance(move);
                } else if (gc.isInitialized(4)) {
                    move = Math.abs(xpos - gc.getX());
                    xpos = gc.getX();
                    gc.setDistance(move);
                } else if (gc.isInitialized(8)) {
                    move = Math.abs(ypos - gc.getY());
                    ypos = gc.getY();
                    gc.setDistance(move);
                } else if (gc.isInitialized(1)) {
                    move = Math.abs(epos - gc.getE());
                } else if (gc.isInitialized(16)) {
                    move = Math.abs(zpos - gc.getZ());
                }
                if (gc.isInitialized(16)) {
                    zpos = gc.getZ();
                }
                if (gc.isInitialized(1)) {
                    float oldepos = gc.getE();
                    gc.setExtrusion(gc.getE() - epos);
                    epos = oldepos;
                }
                gc.setTime(move / (f_new / 60.0f));
                if (f_new >= f_old) {
                    gc.setTimeAccel(move / ((Math.min(2400.0f, f_old) + f_new) / 2.0f / 60.0f));
                } else {
                    gc.setTimeAccel(move / ((f_old + f_new) / 2.0f / 60.0f));
                }
                f_old = f_new;
                if (gc.isInitialized(1) && gc.getE() > 0.0f) {
                    if (pos_changed) {
                        currLayer.addPosition(lastxpos, lastypos, lastzpos);
                    }
                    currLayer.addPosition(xpos, ypos, zpos);
                    pos_changed = true;
                }
            }
            if (gc.getGcode() == Constants.GCDEF.G20 || gc.getGcode() == Constants.GCDEF.G21) {
                currLayer.setUnit(gc.getUnit());
            }
            if (gc.isInitialized(32)) {
                currLayer.setFanspeed(gc.getFanspeed());
            }
            if (gc.isInitialized(64)) {
                extemp = gc.getExtemp();
            } else if (gc.isInitialized(128)) {
                bedtemp = gc.getBedtemp();
            }
            gc.setCurrentPosition(new Position(xpos, ypos));
            currLayer.addGcodes(gc);
        }
        for (Layer closelayer : this.layer) {
            this.endLayer(closelayer);
        }
    }

    void endLayer(Layer lay) {
        this.time += lay.getTime();
        this.timeaccel += lay.getTimeAccel();
        this.distance += lay.getDistance();
        this.traveldistance += lay.getTraveldistance();
        if (!lay.isPrinted()) {
            ++this.notprintedLayers;
        } else {
            this.boundaries[0] = Math.max(lay.getBoundaries()[0], this.boundaries[0]);
            this.boundaries[1] = Math.min(lay.getBoundaries()[1], this.boundaries[1]);
            this.boundaries[2] = Math.max(lay.getBoundaries()[2], this.boundaries[2]);
            this.boundaries[3] = Math.min(lay.getBoundaries()[3], this.boundaries[3]);
            this.boundaries[4] = Math.max(lay.getBoundaries()[4], this.boundaries[4]);
            this.dimension[0] = Constants.round2digits(this.boundaries[0] - this.boundaries[1]);
            this.dimension[1] = Constants.round2digits(this.boundaries[2] - this.boundaries[3]);
            this.dimension[2] = Constants.round2digits(this.boundaries[4]);
            this.extrusion += lay.getExtrusion();
            this.avgLayerHeight += lay.getLayerheight();
            this.avgbedtemp += lay.getBedtemp();
            this.avgextemp += lay.getExttemp();
        }
        float sp = lay.getSpeed(Layer.Speed.SPEED_ALL_AVG);
        if (sp != Float.NaN && sp > 0.0f) {
            this.avgspeed += sp * lay.getDistance();
        }
        this.maxprintspeed = Math.max(this.maxprintspeed, lay.getSpeed(Layer.Speed.SPEED_PRINT_MAX));
        if (lay.getSpeed(Layer.Speed.SPEED_PRINT_MIN) != 0.0f) {
            this.minprintspeed = Math.min(this.minprintspeed, lay.getSpeed(Layer.Speed.SPEED_PRINT_MIN));
        }
        if ((sp = lay.getSpeed(Layer.Speed.SPEED_TRAVEL_AVG)) != Float.NaN && sp > 0.0f) {
            this.avgtravelspeed += sp * lay.getTraveldistance();
        }
        for (float speedkey : lay.getSpeedAnalysisT().keySet()) {
            SpeedEntry timespeedlay = (SpeedEntry)lay.getSpeedAnalysisT().get(Float.valueOf(speedkey));
            SpeedEntry speedsum = (SpeedEntry)this.SpeedAnalysisT.get(Float.valueOf(speedkey));
            if (speedsum != null) {
                speedsum.addTime(timespeedlay.getTime());
                speedsum.addDistance(timespeedlay.getDistance());
                speedsum.setPrint(timespeedlay.getType());
                speedsum.addLayers(lay.getNumber());
                continue;
            }
            SpeedEntry sped = new SpeedEntry(speedkey, timespeedlay.getTime(), lay.getNumber());
            sped.addDistance(timespeedlay.getDistance());
            sped.setPrint(timespeedlay.getType());
            this.SpeedAnalysisT.put(Float.valueOf(speedkey), sped);
        }
        this.unit = lay.getUnit();
    }

    public float getAvgbedtemp() {
        return Constants.round2digits(this.avgbedtemp / (float)this.getLayercount(true));
    }

    public float getAvgextemp() {
        return Constants.round2digits(this.avgextemp / (float)this.getLayercount(true));
    }

    public Material guessMaterial() {
        if (this.getAvgextemp() <= 205.0f && this.getAvgextemp() > 140.0f) {
            return Material.PLA;
        }
        if (this.getAvgextemp() < 290.0f && this.getAvgextemp() > 205.0f) {
            return Material.ABS;
        }
        return Material.UNKNOWN;
    }

    public String guessPrice(float diameter) {
        String var = "";
        if (diameter == 0.0f) {
            diameter = 3.0f;
        }
        double mm3 = (double)(diameter / 2.0f * (diameter / 2.0f)) * Math.PI * (double)this.getExtrusion();
        double weigth = 0.0;
        switch (this.guessMaterial()) {
            case PLA: {
                weigth = mm3 * 0.00125;
            }
            case ABS: {
                weigth = mm3 * 0.00105;
            }
        }
        double priceg = weigth * PRICE_PER_G;
        var = String.valueOf(var) + "Material" + (this.isguessed ? "(guessed):" : ":") + (Object)((Object)this.guessMaterial()) + " " + diameter + "mm\n";
        var = String.valueOf(var) + "Mass:   " + Constants.round2digits((float)mm3 / 1000.0f) + "cm3\n";
        var = String.valueOf(var) + "Weight: " + Constants.round2digits((float)weigth) + "g\n";
        var = String.valueOf(var) + "Price:  " + Constants.round2digits((float)priceg) + "\u20ac\n";
        return var;
    }

    public float guessDiameter() {
        try {
            String dia = System.getenv("FILAMENT_DIAMETER");
            if (dia != null) {
                return Float.parseFloat(dia);
            }
        }
        catch (NumberFormatException dia) {
            // empty catch block
        }
        try {
            ArrayList<GCode> codes = this.getGcodes();
            for (GCode gCode : codes) {
                if (!gCode.isComment()) continue;
                if (gCode.getComment().matches(".*FILAMENT_DIAMETER\\s=.*")) {
                    String[] res = gCode.getComment().split("=");
                    return Float.parseFloat(res[1]);
                }
                if (!gCode.getComment().matches(".*FILAMENT_DIAMETER_.*")) continue;
                String[] res = gCode.getComment().split("[:<]");
                return Float.parseFloat(res[2]);
            }
        }
        catch (Exception codes) {
            // empty catch block
        }
        this.isguessed = true;
        float exRadius = this.getAvgLayerHeight() / 2.0f;
        float WOT = 2.1f;
        double extrArea = (double)(exRadius * (exRadius * WOT)) * Math.PI;
        double menge = extrArea * (double)this.getDistance();
        double sizeArea = menge / (double)this.getExtrusion();
        double guessedDia = Math.sqrt(sizeArea / Math.PI) * 2.0;
        if (guessedDia > (double)2.45f) {
            return 3.0f;
        }
        if (guessedDia < (double)2.05f) {
            return 1.75f;
        }
        return 0.0f;
    }

    public float getAvgLayerHeight() {
        return Constants.round2digits(this.avgLayerHeight / (float)this.getLayercount(true));
    }

    public float[] getBoundaries() {
        return this.boundaries;
    }

    public float[] getDimension() {
        return this.dimension;
    }

    public float getDistance() {
        return Constants.round2digits(this.distance);
    }

    public float getExtrusion() {
        return Constants.round2digits(this.extrusion);
    }

    public String getFilename() {
        return this.filename;
    }

    public int getGcodecount() {
        return this.gcodes.size();
    }

    public ArrayList<GCode> getGcodes() {
        return this.gcodes;
    }

    public ArrayList<Layer> getLayer() {
        return this.layer;
    }

    public Layer getLayer(int number) {
        this.layer.get(number);
        return null;
    }

    public int getLayercount(boolean printedonly) {
        if (printedonly) {
            return this.layercount - this.notprintedLayers;
        }
        return this.layercount;
    }

    public float getSpeed(Layer.Speed type) {
        switch (type) {
            case SPEED_ALL_AVG: {
                return Constants.round2digits(this.avgspeed / this.distance);
            }
            case SPEED_TRAVEL_AVG: {
                return Constants.round2digits(this.avgtravelspeed / this.traveldistance);
            }
            case SPEED_PRINT_AVG: {
                return Constants.round2digits((this.avgspeed - this.avgtravelspeed) / (this.distance - this.traveldistance));
            }
            case SPEED_PRINT_MAX: {
                return this.maxprintspeed;
            }
            case SPEED_PRINT_MIN: {
                return this.minprintspeed;
            }
        }
        return 0.0f;
    }

    public SortedMap<Float, SpeedEntry> getSpeedAnalysisT() {
        return this.SpeedAnalysisT;
    }

    public float getTime() {
        return Constants.round2digits(this.time);
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean loadModel() throws IOException {
        FileInputStream fread = new FileInputStream(this.filename);
        File f = new File(this.filename);
        this.filesize = f.length();
        return this.loadModel(fread);
    }

    public boolean loadModel(InputStream in) throws IOException {
        InputStreamReader fread = new InputStreamReader(in);
        BufferedReader gcread = new BufferedReader(fread, 32768);
        ArrayList<GCode> codes = this.getGcodes();
        String errors = "Error while parsing gcodes:\n";
        int idx = 1;
        int errorcnt = 0;
        int success = 0;
        long time = System.currentTimeMillis();
        System.out.println("Load Model started");
        try {
            String line;
            while ((line = gcread.readLine()) != null) {
                GCode gc = null;
                try {
                    gc = GCodeFactory.getGCode(line, idx++);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error while parsing gcode:" + line + " (line:" + idx + ")");
                }
                if (gc == null || gc.getGcode() == Constants.GCDEF.UNKNOWN) {
                    errors = String.valueOf(errors) + "line:" + idx + "     " + line + "\n";
                    if (++errorcnt - success > 10 || gc == null) {
                        throw new IOException(errors);
                    }
                } else {
                    ++success;
                }
                codes.add(gc);
                this.readbytes += (long)line.length();
            }
        }
        catch (OutOfMemoryError oom) {
            throw new IOException("Out of Memory Error");
        }
        gcread.close();
        System.out.println("Load Model finished in ms:" + (System.currentTimeMillis() - time));
        if (errorcnt != 0) {
            System.err.println("Detected " + errorcnt + " error(s) during parsing of Gcode file. Results might be wrong.");
        }
        return true;
    }

    public boolean loadModelNew(InputStream in) throws IOException {
        InputStreamReader fread = new InputStreamReader(in);
        BufferedReader gcread = new BufferedReader(fread, 32768);
        ArrayList<GCode> codes = this.getGcodes();
        char[] line = new char[1024];
        String errors = "Error while parsing gcodes:\n";
        int idx = 1;
        int errorcnt = 0;
        int success = 0;
        long time = System.currentTimeMillis();
        System.out.println("Load Model started");
        int i = 0;
        while ((line[i] = (char)gcread.read()) != '\uffffffff') {
            if (line[i] != '\n') {
                ++i;
                continue;
            }
            GCode gc = null;
            try {
                gc = GCodeFactory.getGCode(new String(line, 0, i), idx++);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error while parsing gcode:" + line + " (line:" + idx + ")");
            }
            if (gc == null || gc.getGcode() == Constants.GCDEF.UNKNOWN) {
                errors = String.valueOf(errors) + "line:" + idx + "     " + line + "\n";
                if (++errorcnt - success > 10 || gc == null) {
                    throw new IOException(errors);
                }
            } else {
                ++success;
            }
            codes.add(gc);
            this.readbytes += (long)i;
            i = 0;
        }
        gcread.close();
        System.out.println("Load Model finished in ms:" + (System.currentTimeMillis() - time));
        if (errorcnt != 0) {
            System.err.println("Detected " + errorcnt + " error(s) during parsing of Gcode file. Results might be wrong.");
        }
        return true;
    }

    public void saveModel(String newfilename) throws IOException {
        FileWriter fwr = new FileWriter(newfilename);
        BufferedWriter gcwr = new BufferedWriter(fwr);
        for (GCode gc : this.gcodes) {
            gcwr.write(gc.getCodeline().toString());
        }
        gcwr.close();
        fwr.close();
    }

    public String getModelComments() {
        StringBuilder buf = new StringBuilder(500);
        buf.append("--------- Slicer Comments------------\n");
        for (GCode gCode : this.gcodes) {
            if (!gCode.isComment()) continue;
            buf.append(gCode.getComment());
            buf.append('\n');
        }
        return buf.toString();
    }

    public String getModelDetailReport() {
        float time = this.getTime();
        float[] sizes = this.getDimension();
        float[] bound = this.getBoundaries();
        String mm_in = this.getUnit();
        StringBuilder varb = new StringBuilder(600);
        varb.append("Filename:  ");
        varb.append(this.getFilename());
        varb.append('\n');
        varb.append("Layers visited:  ");
        varb.append(this.getLayercount(false));
        varb.append('\n');
        varb.append("Layers printed:  ");
        varb.append(this.getLayercount(true));
        varb.append('\n');
        varb.append("Avg.Layerheight: ");
        varb.append(this.getAvgLayerHeight());
        varb.append(mm_in);
        varb.append('\n');
        varb.append("Size:            ");
        varb.append(sizes[0]);
        varb.append(mm_in);
        varb.append(" x ");
        varb.append(sizes[1]);
        varb.append(mm_in);
        varb.append(" H");
        varb.append(sizes[2]);
        varb.append(mm_in);
        varb.append('\n');
        varb.append("Position on bed: ");
        varb.append(Constants.round2digits(bound[1]));
        varb.append("/");
        varb.append(Constants.round2digits(bound[0]));
        varb.append(mm_in);
        varb.append(" x ");
        varb.append(Constants.round2digits(bound[3]));
        varb.append("/" + Constants.round2digits(bound[2]));
        varb.append(mm_in);
        varb.append(" H");
        varb.append(Constants.round2digits(bound[4]));
        varb.append(mm_in);
        varb.append('\n');
        varb.append("XY Distance:     ");
        varb.append(this.getDistance());
        varb.append(mm_in);
        varb.append('\n');
        varb.append("Extrusion:       ");
        varb.append(this.getExtrusion());
        varb.append(mm_in);
        varb.append('\n');
        varb.append("Bed Temperatur:  ");
        varb.append(this.getAvgbedtemp());
        varb.append("\u00b0\n");
        varb.append("Ext Temperatur:  ");
        varb.append(this.getAvgextemp());
        varb.append("\u00b0\n");
        varb.append("Avg.Speed(All):    ");
        varb.append(this.getSpeed(Layer.Speed.SPEED_ALL_AVG));
        varb.append(mm_in);
        varb.append("/s\n");
        varb.append("Avg.Speed(Print):  ");
        varb.append(this.getSpeed(Layer.Speed.SPEED_PRINT_AVG));
        varb.append(mm_in);
        varb.append("/s\n");
        varb.append("Avg.Speed(Travel): ");
        varb.append(this.getSpeed(Layer.Speed.SPEED_TRAVEL_AVG));
        varb.append(mm_in);
        varb.append("/s\n");
        varb.append("Max.Speed(Print):  ");
        varb.append(this.getSpeed(Layer.Speed.SPEED_PRINT_MAX));
        varb.append(mm_in);
        varb.append("/s\n");
        varb.append("Min.Speed(Print):  ");
        varb.append(this.getSpeed(Layer.Speed.SPEED_PRINT_MIN));
        varb.append(mm_in);
        varb.append("/s\n");
        varb.append("Gcode Lines:     ");
        varb.append(this.getGcodecount());
        varb.append('\n');
        varb.append("Overall Time (w/o Acceleration):   ");
        Constants.formatTimetoHHMMSS(time, varb);
        varb.append(" (");
        varb.append(time);
        varb.append("sec)\n");
        varb.append("Overall Time (w/ Acceleration):    ");
        Constants.formatTimetoHHMMSS(this.timeaccel, varb);
        varb.append(" (");
        varb.append(this.timeaccel);
        varb.append("sec)\n");
        return varb.toString();
    }

    public String getModelSpeedReport() {
        StringBuilder var = new StringBuilder();
        var.append("---------- Model Speed Distribution ------------");
        ArrayList<Float> speeds = new ArrayList<Float>(this.getSpeedAnalysisT().keySet());
        for (float speedval : speeds) {
            SpeedEntry tim = (SpeedEntry)this.getSpeedAnalysisT().get(Float.valueOf(speedval));
            var.append("\n  Speed ");
            var.append(speedval);
            var.append("    ");
            var.append((Object)tim.getType());
            var.append("    Time:");
            var.append(Constants.round2digits(tim.getTime()));
            var.append("sec       ");
            var.append(Constants.round2digits(tim.getTime() / (this.time / 100.0f)));
            var.append('%');
            var.append("     Layers:[");
            int max = 4;
            Iterator<Integer> layrs = tim.getLayers().iterator();
            while (layrs.hasNext()) {
                var.append(' ');
                var.append(layrs.next());
                if (--max != 0) continue;
                var.append(" ...");
                break;
            }
            var.append(" ]");
        }
        return var.toString();
    }

    public String getModelLayerSummaryReport() {
        ArrayList<Layer> layers = new ArrayList<Layer>(this.getLayer());
        StringBuilder var = new StringBuilder();
        var.append("---------- Printed Layer Summary ------------\n");
        for (Layer lay : layers) {
            if (!lay.isPrinted()) continue;
            float layperc = Constants.round2digits(lay.getTime() / (this.getTime() / 100.0f));
            var.append("  ");
            var.append(lay.getLayerSummaryReport());
            var.append("  ");
            var.append(layperc);
            var.append("%\n");
        }
        return var.toString();
    }

    Layer startLayer(float z, Layer prevLayer) {
        if (prevLayer != null && z == prevLayer.getZPosition()) {
            return prevLayer;
        }
        Layer lay = null;
        int fanspeed = 0;
        float bedtemp = 0.0f;
        float extemp = 0.0f;
        float lh = z;
        if (prevLayer != null) {
            if (prevLayer.isPrinted()) {
                lh = z - prevLayer.getZPosition();
            }
            fanspeed = prevLayer.getFanspeed();
            bedtemp = prevLayer.getBedtemp();
            extemp = prevLayer.getExttemp();
        }
        lay = new Layer(z, this.layercount, Constants.round2digits(lh));
        lay.setUnit(this.unit);
        lay.setFanspeed(fanspeed);
        lay.setBedtemp(bedtemp);
        lay.setExttemp(extemp);
        this.layer.add(lay);
        ++this.layercount;
        return lay;
    }

    public float getTimeaccel() {
        return this.timeaccel;
    }

    public static void deleteLayer(Collection<Layer> lays) {
        System.out.println("Delete Layer " + lays);
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeToComment(gCode);
            }
        }
    }

    public static void changeFan(Collection<Layer> lays, int value) {
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeFan(gCode, value);
            }
        }
    }

    public static void changeXOffset(Collection<Layer> lays, float value) {
        System.out.println("Add X Offset " + value);
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeXOffset(gCode, value);
            }
        }
    }

    public static void changeYOffset(Collection<Layer> lays, float value) {
        System.out.println("Add Y Offset " + value);
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeYOffset(gCode, value);
            }
        }
    }

    public static void changeZOffset(Collection<Layer> lays, float value) {
        System.out.println("Add Z Offset " + value);
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeZOffset(gCode, value);
            }
        }
    }

    public static void changeLayerHeight(Collection<Layer> lays, int value) {
        System.out.println("Change Layerheight by " + value + "%");
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeLayerHeight(gCode, value);
            }
        }
    }

    public static void changeBedTemp(Collection<Layer> lays, float value) {
        System.out.println("Set Bed temp to " + value);
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeBedTemp(gCode, value);
            }
        }
    }

    public static void changeExtTemp(Collection<Layer> lays, float value) {
        System.out.println("Set Extruder temp to " + value);
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeExtTemp(gCode, value);
            }
        }
    }

    public static void changeExtrusion(Collection<Layer> lays, int value) {
        System.out.println("Change Extrusion by " + value + "%");
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeExtrusion(gCode, value);
            }
        }
    }

    public static void changeSpeed(Collection<Layer> lays, int value) {
        System.out.println("Change Speed by " + value + "%");
        for (Layer layer : lays) {
            ArrayList<GCode> gcodes = layer.getGcodes();
            for (GCode gCode : gcodes) {
                GCodeMod.changeSpeed(gCode, value, true);
            }
        }
    }

    public static enum Material {
        PLA,
        ABS,
        UNKNOWN;

    }
}

