/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialTest {
    void connect(String portName) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            System.out.println("Error: Port is currently in use");
        } else {
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(115200, 8, 1, 0);
                InputStream in = serialPort.getInputStream();
                OutputStream out = serialPort.getOutputStream();
                new Thread(new SerialReader(in)).start();
                new Thread(new SerialWriter(out)).start();
            } else {
                System.out.println("Error: Only serial ports are handled by this example.");
            }
        }
    }

    public static void main(String[] args) {
        try {
            new SerialTest().connect("/dev/ttyUSB0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SerialReader
    implements Runnable {
        InputStream in;

        public SerialReader(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            int len = -1;
            try {
                while ((len = this.in.read(buffer)) > -1) {
                    System.out.print(new String(buffer, 0, len));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class SerialWriter
    implements Runnable {
        OutputStream out;

        public SerialWriter(OutputStream out) {
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int c = 0;
                while ((c = System.in.read()) > -1) {
                    this.out.write(c);
                    System.out.println(c);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

