/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodes;

import de.dietzm.Constants;
import de.dietzm.gcodes.GCode;
import de.dietzm.gcodes.GCodeMemSave;

public class GCodeFactory {
    static GCodeFactory factory = new GCodeFactory();

    public static void setCustomFactory(GCodeFactory custom) {
        factory = custom;
    }

    public static GCode getGCode(String line, int linenr) {
        return factory.parseGcode(line, linenr);
    }

    public static void main(String[] args) {
        System.out.println("Split");
        String s = " G1 Z5 F5000\n";
        long time = System.nanoTime();
        int i = 0;
        while (i < 100) {
            s.split(" ");
            ++i;
        }
        System.out.println("Split:" + (System.nanoTime() - time));
        time = System.nanoTime();
        i = 0;
        while (i < 100) {
            Constants.splitbyLetter(s);
            ++i;
        }
        System.out.println("SplitBy:" + (System.nanoTime() - time));
        time = System.nanoTime();
        i = 0;
        while (i < 100) {
            Constants.splitbyLetter2(s);
            ++i;
        }
        System.out.println("SplitBy:" + (System.nanoTime() - time));
        String[] str = Constants.splitbyLetter2(s);
        int i2 = 0;
        while (i2 < str.length) {
            System.out.println("-" + str[i2] + "-");
            System.out.println("Len:" + str[i2].length());
            ++i2;
        }
    }

    private GCode parseGcode(String arg0, int linenr) {
        String codelinevar = arg0;
        Constants.GCDEF tmpgcode = Constants.GCDEF.UNKNOWN;
        if ((codelinevar = this.stripComment(codelinevar)).length() == 0) {
            return this.createDefaultGCode(arg0, linenr, Constants.GCDEF.COMMENT);
        }
        if (!Constants.isValidGCode(codelinevar)) {
            GCode min = this.createDefaultGCode(arg0, linenr, Constants.GCDEF.UNKNOWN);
            return min;
        }
        String[] segments = Constants.splitbyLetter2(codelinevar);
        codelinevar = codelinevar.length() > segments[0].length() && codelinevar.charAt(segments[0].length()) == ' ' ? codelinevar.substring(Math.min(segments[0].length() + 1, codelinevar.length())) : codelinevar.substring(Math.min(segments[0].length(), codelinevar.length()));
        try {
            tmpgcode = Constants.GCDEF.getGCDEF(segments[0]);
        }
        catch (Exception e1) {
            System.err.println("Parse GCODE GCDEF Exception:" + e1);
        }
        GCode gcd = null;
        switch (tmpgcode) {
            case G0: 
            case G1: {
                gcd = this.findMatches(segments, codelinevar, linenr, tmpgcode);
                break;
            }
            case G2: 
            case G3: {
                gcd = this.findMatches(segments, codelinevar, linenr, tmpgcode);
                System.err.println("Experimental support of Gcode G2/G3.");
                break;
            }
            case G4: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case G92: {
                gcd = this.findMatches(segments, codelinevar, linenr, tmpgcode);
                break;
            }
            case M140: 
            case M190: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                Character id = Character.valueOf(segments[1].charAt(0));
                if (id.charValue() != 'S' && id.charValue() != 's') break;
                gcd.setInitialized((short)128, Constants.parseFloat(segments[1], 1));
                break;
            }
            case M104: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                Character id = Character.valueOf(segments[1].charAt(0));
                if (id.charValue() != 'S' && id.charValue() != 's') break;
                gcd.setInitialized((short)64, Constants.parseFloat(segments[1], 1));
                break;
            }
            case G90: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case M82: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case G91: 
            case M83: {
                System.err.println("G91/M83 Relative Positioning is NOT supported.");
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case G20: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                gcd.setUnit("in");
                break;
            }
            case G21: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                gcd.setUnit("mm");
                break;
            }
            case M109: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                Character id = Character.valueOf(segments[1].charAt(0));
                if (id.charValue() != 'S' && id.charValue() != 's') break;
                gcd.setInitialized((short)64, Constants.parseFloat(segments[1], 1));
                break;
            }
            case G28: 
            case G161: 
            case G162: {
                gcd = this.createOptimizedGCode(segments, codelinevar, linenr, tmpgcode);
                if (segments.length == 1) {
                    gcd.setInitialized((short)4, 0.0f);
                    gcd.setInitialized((short)8, 0.0f);
                    gcd.setInitialized((short)16, 0.0f);
                    break;
                }
                int i = 1;
                while (i < segments.length) {
                    Character id = Character.valueOf(segments[i].charAt(0));
                    switch (id.charValue()) {
                        case 'X': 
                        case 'x': {
                            gcd.setInitialized((short)4, 0.0f);
                            break;
                        }
                        case 'Y': 
                        case 'y': {
                            gcd.setInitialized((short)8, 0.0f);
                            break;
                        }
                        case 'Z': 
                        case 'z': {
                            gcd.setInitialized((short)16, 0.0f);
                        }
                    }
                    ++i;
                }
                break;
            }
            case M107: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                gcd.setInitialized((short)32, 0.0f);
                break;
            }
            case M106: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                if (segments.length == 1) {
                    gcd.setInitialized((short)32, 255.0f);
                    break;
                }
                Character id = Character.valueOf(segments[1].charAt(0));
                if (id.charValue() != 'S' && id.charValue() != 's') break;
                gcd.setInitialized((short)32, Constants.parseFloat(segments[1], 1));
                break;
            }
            case G130: 
            case M0: 
            case M1: 
            case M6: 
            case M18: 
            case M92: 
            case M105: 
            case M114: 
            case M116: 
            case M117: 
            case M132: 
            case M84: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case M101: 
            case M103: 
            case M113: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case M70: 
            case M72: 
            case M73: {
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case M108: {
                System.err.println("Deprecated Gcode M108. Ignoring it.");
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case M204: {
                System.err.println("M204 Acceleration control is ignored.");
                gcd = this.createDefaultGCode(codelinevar, linenr, tmpgcode);
                break;
            }
            case UNKNOWN: {
                System.err.println("Unknown Gcode " + linenr + ": " + (Object)((Object)tmpgcode) + " " + segments[0] + " " + codelinevar.substring(0, Math.min(15, codelinevar.length())) + "....");
                gcd = this.createDefaultGCode(String.valueOf(segments[0]) + " " + codelinevar, linenr, tmpgcode);
                break;
            }
            default: {
                return this.createDefaultGCode(codelinevar, linenr, tmpgcode);
            }
        }
        if (gcd == null) {
            return this.createDefaultGCode(codelinevar, linenr, tmpgcode);
        }
        return gcd;
    }

    protected GCode findMatches(String[] segments, String line, int linenr, Constants.GCDEF code) {
        GCode gcd = this.createOptimizedGCode(segments, line, linenr, code);
        int i = 1;
        while (i < segments.length) {
            if (segments[i].length() != 0) {
                Character id = Character.valueOf(segments[i].charAt(0));
                switch (id.charValue()) {
                    case 'A': 
                    case 'B': 
                    case 'E': 
                    case 'a': 
                    case 'b': 
                    case 'e': {
                        gcd.setInitialized((short)1, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        gcd.setInitialized((short)4, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'Y': 
                    case 'y': {
                        gcd.setInitialized((short)8, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        gcd.setInitialized((short)16, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        gcd.setInitialized((short)2, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        gcd.setInitialized((short)512, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'J': 
                    case 'j': {
                        gcd.setInitialized((short)1024, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        gcd.setInitialized((short)2048, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        gcd.setInitialized((short)256, Constants.parseFloat(segments[i], 1));
                        break;
                    }
                }
            }
            ++i;
        }
        return gcd;
    }

    protected GCode createOptimizedGCode(String[] segments, String line, int linenr, Constants.GCDEF code) {
        return this.createDefaultGCode(line, linenr, code);
    }

    protected GCode createDefaultGCode(String line, int linenr, Constants.GCDEF code) {
        GCodeMemSave gcd = new GCodeMemSave(line, linenr, code);
        return gcd;
    }

    private String stripComment(String clv) {
        int idx = clv.indexOf(59);
        if (idx != -1) {
            clv = clv.substring(0, idx);
        } else {
            idx = clv.indexOf("(");
            if (idx != -1) {
                clv = clv.substring(0, idx);
            }
        }
        return clv.trim();
    }
}

