/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.print;

import de.dietzm.gcodes.GCode;
import de.dietzm.gcodes.MemoryEfficientString;
import de.dietzm.print.ConsoleIf;
import de.dietzm.print.PrinterConnection;
import de.dietzm.print.ReceiveBuffer;
import de.dietzm.print.SerialPrinter;

public class Dummy
implements PrinterConnection {
    boolean isM105 = false;
    boolean isReset = false;
    boolean isSend = false;
    boolean odd = false;
    byte[] memT = new MemoryEfficientString("ok T:179.2 /0.0 B:50.6 /0.0 T0:14.9 /0.0 @:0 B@:0\n").getBytes();
    byte[] memT1 = new MemoryEfficientString("ok T:181.2 /0.0 B:48.6 /0.0 T0:10.9 /0.0 @:0 B@:0\n").getBytes();
    byte[] memS = new MemoryEfficientString("start grbl\n").getBytes();
    SerialPrinter sio;
    ConsoleIf cons;
    GCode[] buffer = new GCode[16];
    int buffercnt = 0;
    int bufferpos = 0;
    int sdcnt = 0;
    String sendbuf = "";

    public Dummy(SerialPrinter sio, ConsoleIf cons) {
        this.sio = sio;
        this.cons = cons;
    }

    @Override
    public void reset() throws Exception {
        this.isReset = true;
        this.isSend = true;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean init(boolean reset) throws Exception {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        this.cons.appendText("start");
        this.cons.appendText("Dummy Marlin V1.00");
        this.cons.appendText("Successfully connected !");
        return true;
    }

    @Override
    public int tryrecover() {
        return 0;
    }

    @Override
    public boolean enumerate() {
        this.cons.chooseDialog(new String[]{"USB1", "USB2"}, new String[]{"USB1", "USB2"}, 1);
        return true;
    }

    @Override
    public void requestDevice(String device) {
        this.cons.appendText("Waiting for printer response");
        this.sio.startRunnerThread();
    }

    @Override
    public void closeDevice() throws Exception {
    }

    @Override
    public void writeBuffer(ReceiveBuffer wbuf) {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (wbuf.length() >= 4 && wbuf.charAt(0) == 'M' && wbuf.charAt(1) == '1' && wbuf.charAt(2) == '0' && wbuf.charAt(3) == '5') {
            this.isM105 = true;
        }
        this.sendbuf = wbuf.toString();
        this.isSend = true;
        this.buffer[this.bufferpos++] = this.sio.state.lastgcode;
        ++this.buffercnt;
    }

    @Override
    public void read(ReceiveBuffer rbuf) {
        try {
            if (this.buffercnt == this.buffer.length) {
                this.bufferpos = 0;
                Thread.sleep((long)(this.buffer[this.bufferpos].getTimeAccel() * 1000.0f));
                --this.buffercnt;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!this.isSend) {
            return;
        }
        this.isSend = false;
        if (this.isM105) {
            if (this.odd) {
                System.arraycopy(this.memT, 0, rbuf.array, 0, this.memT.length);
                rbuf.setlength(this.memT.length);
            } else {
                System.arraycopy(this.memT1, 0, rbuf.array, 0, this.memT1.length);
                rbuf.setlength(this.memT1.length);
            }
            this.odd = !this.odd;
            this.isM105 = false;
        } else if (this.sendbuf.startsWith("M20")) {
            byte[] sd1 = new MemoryEfficientString("begin\nfile1.gco\nfile2.gco\nfile3.gco\nfile4.gco\nend\nok\n").getBytes();
            System.arraycopy(sd1, 0, rbuf.array, 0, sd1.length);
            rbuf.setlength(sd1.length);
        } else if (this.sendbuf.startsWith("M27")) {
            ++this.sdcnt;
            if (this.sdcnt < 10) {
                byte[] sd1 = new MemoryEfficientString("SD printing byte " + this.sdcnt * 100 + "/1000\nok\n").getBytes();
                System.arraycopy(sd1, 0, rbuf.array, 0, sd1.length);
                rbuf.setlength(sd1.length);
            } else {
                byte[] sd1 = new MemoryEfficientString("SD printing byte 1000/1000\nok\nPrinting done\nok\n").getBytes();
                System.arraycopy(sd1, 0, rbuf.array, 0, sd1.length);
                rbuf.setlength(sd1.length);
                if (this.sdcnt > 15) {
                    this.sdcnt = 0;
                }
            }
        } else if (this.isReset) {
            System.arraycopy(this.memS, 0, rbuf.array, 0, this.memS.length);
            rbuf.setlength(this.memS.length);
            this.isReset = false;
        } else {
            rbuf.array[0] = 111;
            rbuf.array[1] = 107;
            rbuf.array[2] = 10;
            rbuf.setlength(3);
        }
    }

    public ReceiveBuffer read(boolean clear) {
        return null;
    }

    @Override
    public int getType() {
        return 0;
    }
}

