/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm;

import de.dietzm.Constants;
import de.dietzm.SpeedEntry;
import de.dietzm.gcodes.GCode;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;

public class Layer
implements Comparable<Layer> {
    private float avgspeed = 0.0f;
    private float avgtravelspeed = 0.0f;
    private float maxprintspeed = 0.0f;
    private float minprintspeed = Float.MAX_VALUE;
    private float bedtemp;
    private float exttemp;
    private float[] boundaries = new float[]{0.0f, 9999.0f, 0.0f, 9999.0f, 0.0f};
    private float[] dimension = new float[3];
    private float distance = 0.0f;
    private float extrusion = 0.0f;
    private float fantime = 0.0f;
    private int fanspeed = 0;
    private ArrayList<GCode> gcodes = new ArrayList();
    private float Layerheight;
    private boolean isprinted = false;
    private int number;
    private SortedMap<Float, SpeedEntry> SpeedAnalysisT = new TreeMap<Float, SpeedEntry>();
    private float time = 0.0f;
    private float timeaccel = 0.0f;
    float traveldistance = 0.0f;
    private String unit = "mm";
    private float zPosition;

    public Layer(float zPosition) {
        this.zPosition = zPosition;
    }

    public Layer(float zPosition, int num, float lheight) {
        this.zPosition = zPosition;
        this.number = num;
        this.Layerheight = lheight;
    }

    void addGcodes(GCode gcode) {
        float sp;
        this.gcodes.add(gcode);
        this.time += gcode.getTime();
        this.timeaccel += gcode.getTimeAccel();
        this.distance += gcode.getDistance();
        if (!gcode.isExtruding()) {
            this.traveldistance += gcode.getDistance();
        }
        gcode.setFanspeed(this.fanspeed);
        if (this.fanspeed != 0) {
            this.fantime += gcode.getTime();
        }
        if ((sp = gcode.getSpeed()) != Float.NaN && sp > 0.0f) {
            this.avgspeed += sp * gcode.getDistance();
            this.categorizeSpeed(gcode, sp);
            if (gcode.isExtruding()) {
                this.isprinted = true;
                this.maxprintspeed = Math.max(this.maxprintspeed, sp);
                this.minprintspeed = Math.min(this.minprintspeed, sp);
            } else {
                this.avgtravelspeed += sp * gcode.getDistance();
            }
        }
        this.extrusion += gcode.getExtrusion();
    }

    public int getFanspeed() {
        return this.fanspeed;
    }

    public void setFanspeed(int fanspeed) {
        this.fanspeed = fanspeed;
    }

    void addPosition(float x, float y, float z) {
        this.boundaries[0] = Math.max(x, this.boundaries[0]);
        this.boundaries[1] = Math.min(x, this.boundaries[1]);
        this.boundaries[2] = Math.max(y, this.boundaries[2]);
        this.boundaries[3] = Math.min(y, this.boundaries[3]);
        this.boundaries[4] = Math.max(z, this.boundaries[4]);
        this.dimension[0] = this.boundaries[0] - this.boundaries[1];
        this.dimension[1] = this.boundaries[2] - this.boundaries[3];
        this.dimension[2] = this.Layerheight;
    }

    private void categorizeSpeed(GCode gcode, float sp) {
        SpeedEntry timeforspeed = (SpeedEntry)this.SpeedAnalysisT.get(Float.valueOf(sp = (float)Math.round(sp)));
        if (timeforspeed != null) {
            timeforspeed.addTime(gcode.getTime());
            timeforspeed.addDistance(gcode.getDistance());
            if (gcode.isExtruding()) {
                timeforspeed.setPrint(SpeedEntry.Speedtype.PRINT);
            } else {
                timeforspeed.setPrint(SpeedEntry.Speedtype.TRAVEL);
            }
        } else {
            SpeedEntry sped = new SpeedEntry(sp, gcode.getTime(), this.number);
            sped.addDistance(gcode.getDistance());
            if (gcode.isExtruding()) {
                sped.setPrint(SpeedEntry.Speedtype.PRINT);
            } else {
                sped.setPrint(SpeedEntry.Speedtype.TRAVEL);
            }
            this.SpeedAnalysisT.put(Float.valueOf(sp), sped);
        }
    }

    @Override
    public int compareTo(Layer o) {
        return Float.compare(this.zPosition, o.getZPosition());
    }

    public float getBedtemp() {
        return this.bedtemp;
    }

    public float[] getBoundaries() {
        return this.boundaries;
    }

    public float[] getDimension() {
        return this.dimension;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getExtrusion() {
        return this.extrusion;
    }

    public float getExttemp() {
        return this.exttemp;
    }

    protected void setExttemp(float ext) {
        this.exttemp = ext;
    }

    protected void setBedtemp(float bet) {
        this.bedtemp = bet;
    }

    public ArrayList<GCode> getGcodes() {
        return this.gcodes;
    }

    public float getLayerheight() {
        return this.Layerheight;
    }

    public int getNumber() {
        return this.number;
    }

    public float getSpeed(Speed type) {
        switch (type) {
            case SPEED_ALL_AVG: {
                return Constants.round2digits(this.avgspeed / this.distance);
            }
            case SPEED_TRAVEL_AVG: {
                return Constants.round2digits(this.avgtravelspeed / this.traveldistance);
            }
            case SPEED_PRINT_AVG: {
                return Constants.round2digits((this.avgspeed - this.avgtravelspeed) / (this.distance - this.traveldistance));
            }
            case SPEED_PRINT_MAX: {
                return this.maxprintspeed;
            }
            case SPEED_PRINT_MIN: {
                if (this.minprintspeed == Float.MAX_VALUE) {
                    return 0.0f;
                }
                return this.minprintspeed;
            }
        }
        return 0.0f;
    }

    public SortedMap<Float, SpeedEntry> getSpeedAnalysisT() {
        return this.SpeedAnalysisT;
    }

    public float getTime() {
        return this.time;
    }

    public float getTimeAccel() {
        return this.timeaccel;
    }

    public float getTraveldistance() {
        return this.traveldistance;
    }

    public String getUnit() {
        return this.unit;
    }

    public float getZPosition() {
        return this.zPosition;
    }

    public boolean isPrinted() {
        return this.isprinted;
    }

    void setLayerheight(float layerheight) {
        this.Layerheight = layerheight;
    }

    void setTraveldistance(float traveldistance) {
        this.traveldistance = traveldistance;
    }

    void setUnit(String unit) {
        this.unit = unit;
    }

    public String toString() {
        String var = this.getLayerDetailReport();
        String var2 = this.getLayerSpeedReport();
        return String.valueOf(var) + var2 + "\n----------------------------------------------------------";
    }

    public String getLayerSpeedReport() {
        ArrayList<Float> speeds = new ArrayList<Float>(this.SpeedAnalysisT.keySet());
        StringBuilder var2 = new StringBuilder();
        var2.append("---------- Layer #");
        var2.append(this.number);
        var2.append(" Speed Distribution ------------");
        for (float speedval : speeds) {
            SpeedEntry tim = (SpeedEntry)this.SpeedAnalysisT.get(Float.valueOf(speedval));
            var2.append("\n    Speed ");
            var2.append(speedval);
            var2.append("    ");
            var2.append((Object)tim.getType());
            var2.append("     Distance:");
            var2.append(Constants.round2digits(tim.getDistance() / (this.distance / 100.0f)));
            var2.append('%');
            var2.append("      Time:");
            var2.append(Constants.round2digits(tim.getTime()));
            var2.append("sec/");
            var2.append(Constants.round2digits(tim.getTime() / (this.time / 100.0f)));
            var2.append('%');
        }
        return var2.toString();
    }

    public String getLayerDetailReport() {
        StringBuilder var = new StringBuilder(500);
        var.append('#');
        var.append(this.number);
        var.append(" Height: ");
        var.append(this.zPosition);
        var.append(this.unit);
        var.append("\n LayerHeight: ");
        var.append(this.Layerheight);
        var.append(this.unit);
        var.append("\n Is Printed: ");
        var.append(this.isPrinted());
        var.append("\n Print Time: ");
        Constants.formatTimetoHHMMSS(this.time, var);
        var.append("\n Print Time (Accel): ");
        Constants.formatTimetoHHMMSS(this.timeaccel, var);
        var.append("\n Distance (All/travel): ");
        var.append(Constants.round2digits(this.distance));
        var.append('/');
        var.append(Constants.round2digits(this.traveldistance));
        var.append(this.unit);
        var.append("\n Extrusion: ");
        var.append(Constants.round2digits(this.extrusion));
        var.append(this.unit);
        var.append("\n Bed Temperatur:");
        var.append(this.bedtemp);
        var.append('\u00b0');
        var.append("\n Extruder Temperatur:");
        var.append(this.exttemp);
        var.append('\u00b0');
        var.append("\n Cooling Time (Fan): ");
        var.append(Constants.round2digits(this.fantime / (this.time / 100.0f)));
        var.append('%');
        var.append("\n GCodes: ");
        var.append(this.gcodes.size());
        var.append("\n GCode Linenr: ");
        var.append(this.gcodes.get(0).getLineindex());
        var.append("\n Dimension: ");
        var.append(Constants.round2digits(this.dimension[0]));
        var.append(this.unit);
        var.append(" x ");
        var.append(Constants.round2digits(this.dimension[1]));
        var.append(this.unit);
        var.append(" x");
        var.append(Constants.round2digits(this.dimension[2]));
        var.append(this.unit);
        var.append("\n Avg.Speed(All): ");
        var.append(this.getSpeed(Speed.SPEED_ALL_AVG));
        var.append(this.unit);
        var.append("/s\n Avg.Speed(Print): ");
        var.append(this.getSpeed(Speed.SPEED_PRINT_AVG));
        var.append(this.unit);
        var.append("/s\n Avg.Speed(Travel): ");
        var.append(this.getSpeed(Speed.SPEED_TRAVEL_AVG));
        var.append(this.unit);
        var.append("/s\n Max.Speed(Print): ");
        var.append(this.getSpeed(Speed.SPEED_PRINT_MAX));
        var.append(this.unit);
        var.append("/s\n Min.Speed(Print): ");
        var.append(this.getSpeed(Speed.SPEED_PRINT_MIN));
        var.append(this.unit);
        var.append("/s");
        return var.toString();
    }

    public String getLayerSummaryReport() {
        StringBuilder var = new StringBuilder();
        var.append('#');
        var.append(this.number);
        var.append("   H:");
        var.append(this.zPosition);
        var.append('/');
        var.append(this.Layerheight);
        var.append(this.unit);
        var.append("   T:");
        var.append(Constants.removeTrailingZeros(Float.toString(this.exttemp)));
        var.append("/");
        var.append(Constants.removeTrailingZeros(Float.toString(this.bedtemp)));
        var.append('\u00b0');
        var.append("  ");
        var.append(this.getSpeed(Speed.SPEED_PRINT_AVG));
        var.append(this.unit);
        var.append("/s");
        var.append("   Time: ");
        Constants.formatTimetoHHMMSS(this.time, var);
        return var.toString();
    }

    public static enum Speed {
        SPEED_ALL_AVG,
        SPEED_PRINT_AVG,
        SPEED_PRINT_MAX,
        SPEED_PRINT_MIN,
        SPEED_TRAVEL_AVG;

    }
}

