/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodes;

import de.dietzm.Constants;
import de.dietzm.Position;
import de.dietzm.gcodes.GCode;
import de.dietzm.gcodes.MemoryEfficientString;

@Deprecated
public class GCodeFull
extends GCode {
    private byte[] data;
    private short gcode;
    private int lineindex;
    private short commentidx = (short)-1;
    private float e = Float.MAX_VALUE;
    private float f = Float.MAX_VALUE;
    private float x = Float.MAX_VALUE;
    private float y = Float.MAX_VALUE;
    private float z = Float.MAX_VALUE;
    private Extended ext = null;
    private float time;
    private float timeaccel;
    private float distance;
    private float extrusion;
    private short fanspeed;
    private float curX;
    private float curY;

    @Override
    public short getFanspeed() {
        return this.fanspeed;
    }

    @Override
    public void setFanspeed(float fanspeed) {
        this.fanspeed = (short)fanspeed;
    }

    @Override
    public float getExtemp() {
        if (!this.isInitialized(64)) {
            return -255.0f;
        }
        return this.ext.s_ext;
    }

    @Override
    public float getBedtemp() {
        if (!this.isInitialized(128)) {
            return -255.0f;
        }
        return this.ext.s_bed;
    }

    @Override
    public MemoryEfficientString getCodeline() {
        return new MemoryEfficientString(this.data);
    }

    public MemoryEfficientString getCodelineToPrint() {
        if (this.commentidx != -1) {
            return this.subSequence(0, this.commentidx);
        }
        return new MemoryEfficientString(this.data);
    }

    public GCodeFull(String line, int linenr, Constants.GCDEF gc) {
        super(line, linenr, gc);
    }

    @Override
    public float getS_Bed() {
        return this.ext.s_bed;
    }

    @Override
    public String getComment() {
        return this.subSequence(this.commentidx, this.data.length).toString();
    }

    @Override
    public Position getCurrentPosition(Position pos) {
        pos.x = this.curX;
        pos.y = this.curY;
        return pos;
    }

    @Override
    public float getDistance() {
        return this.distance;
    }

    @Override
    public float getE() {
        return this.e;
    }

    @Override
    public float getS_Ext() {
        return this.ext.s_ext;
    }

    @Override
    public float getExtrusion() {
        return this.extrusion;
    }

    @Override
    public float getF() {
        return this.f;
    }

    @Override
    public float getS_Fan() {
        return this.ext.s_fan;
    }

    @Override
    public Constants.GCDEF getGcode() {
        return Constants.GCDEF.getGCDEF(this.gcode);
    }

    @Override
    public int getLineindex() {
        return this.lineindex;
    }

    @Override
    public Position getPosition(Position reference) {
        return new Position(this.isInitialized(4) ? this.x : reference.x, this.isInitialized(8) ? this.y : reference.y);
    }

    @Override
    public float getSpeed() {
        return Constants.round2digits(this.distance / this.time);
    }

    public void changeSpeed(int percent, boolean printonly) {
        if (printonly && !this.isExtruding()) {
            return;
        }
        if (this.isInitialized(2)) {
            this.f += this.f / 100.0f * (float)percent;
        }
        this.update();
    }

    public void changeExtrusion(int percent) {
        if (this.isInitialized(1)) {
            this.e += this.e / 100.0f * (float)percent;
            this.update();
        }
    }

    public void changeLayerHeight(int percent) {
        if (this.isInitialized(16)) {
            this.z += this.z / 100.0f * (float)percent;
            this.update();
        }
        if (this.isInitialized(1)) {
            this.e += this.e / 100.0f * (float)percent;
            this.update();
        }
    }

    public void changeZOffset(float value) {
        if (this.isInitialized(16)) {
            this.z += value;
            this.update();
        }
    }

    public void changeYOffset(float value) {
        if (this.isInitialized(8)) {
            this.y += value;
            this.update();
        }
    }

    public void changeXOffset(float value) {
        if (this.isInitialized(4)) {
            this.x += value;
            this.update();
        }
    }

    public void changeToComment() {
        MemoryEfficientString mes = this.getCodeline();
        this.data = new MemoryEfficientString(";" + mes).getBytes();
    }

    public void changeFan(int value) {
        if (this.isInitialized(32)) {
            this.ext.s_fan = Float.valueOf(value).floatValue();
            this.update();
        }
    }

    public void changeExtTemp(float extr) {
        if (this.isInitialized(64)) {
            this.ext.s_ext = extr;
            this.update();
        }
    }

    public void changeBedTemp(float bed) {
        if (this.isInitialized(128)) {
            this.ext.s_bed = bed;
            this.update();
        }
    }

    private void update() {
        Constants.GCDEF gd = Constants.GCDEF.getGCDEF(this.gcode);
    }

    @Override
    public float getTime() {
        return this.time;
    }

    @Override
    public String getUnit() {
        return this.ext.unit;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getIx() {
        return this.ext.ix;
    }

    @Override
    public float getJy() {
        return this.ext.jy;
    }

    @Override
    public float getKz() {
        return this.ext.kz;
    }

    @Override
    public float getR() {
        return this.ext.r;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public boolean isExtrudeOrRetract() {
        return this.isInitialized(1) && this.e != 0.0f;
    }

    @Override
    public boolean isExtruding() {
        return this.isInitialized(1) && this.extrusion > 0.0f;
    }

    @Override
    public boolean isPrintable() {
        return !Constants.GCDEF.COMMENT.equals(this.gcode);
    }

    @Override
    public boolean isComment() {
        return Constants.GCDEF.COMMENT.equals(this.gcode) && this.commentidx != -1;
    }

    @Override
    public boolean isBuffered() {
        return Constants.GCDEF.G0.equals(this.gcode) || Constants.GCDEF.G1.equals(this.gcode) || Constants.GCDEF.G2.equals(this.gcode) || Constants.GCDEF.M106.equals(this.gcode) || Constants.GCDEF.M107.equals(this.gcode) || Constants.GCDEF.G29.equals(this.gcode) || Constants.GCDEF.G30.equals(this.gcode) || Constants.GCDEF.G31.equals(this.gcode) || Constants.GCDEF.G32.equals(this.gcode);
    }

    @Override
    public boolean isLongRunning() {
        return Constants.GCDEF.M190.equals(this.gcode) || Constants.GCDEF.M109.equals(this.gcode) || Constants.GCDEF.G28.equals(this.gcode);
    }

    @Override
    public void setCurrentPosition(Position currentPosition) {
        this.curX = currentPosition.x;
        this.curY = currentPosition.y;
    }

    @Override
    public void setDistance(float distance) {
        this.distance = distance;
    }

    @Override
    public void setExtrusion(float extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public void setLineindex(int lineindex) {
        this.lineindex = lineindex;
    }

    @Override
    public void setTime(float time) {
        this.time = time;
    }

    @Override
    public void setTimeAccel(float time) {
        this.timeaccel = time;
    }

    @Override
    public float getTimeAccel() {
        return this.timeaccel;
    }

    @Override
    public float getExtrusionSpeed() {
        return this.extrusion / this.timeaccel * 60.0f;
    }

    @Override
    public String toString() {
        String var = String.valueOf(this.lineindex) + ":  " + this.toStringRaw();
        var = String.valueOf(var) + "\tExtrusion:" + this.extrusion;
        var = String.valueOf(var) + "\tDistance:" + this.distance;
        var = String.valueOf(var) + "\tPosition:" + this.curX + "x" + this.curY;
        var = String.valueOf(var) + "\tTime:" + this.time;
        return var;
    }

    @Override
    public String toCSV() {
        String var = String.valueOf(this.getSpeed());
        var = String.valueOf(var) + ";" + this.extrusion;
        var = String.valueOf(var) + ";" + this.distance;
        var = String.valueOf(var) + ";" + this.time;
        var = String.valueOf(var) + ";" + this.fanspeed;
        return var;
    }

    @Override
    public void setInitialized(short mask, float value) {
        if (mask > 16 && this.ext == null) {
            this.ext = new Extended();
        }
        switch (mask) {
            case 1: {
                this.e = value;
                break;
            }
            case 4: {
                this.x = value;
                break;
            }
            case 8: {
                this.y = value;
                break;
            }
            case 16: {
                this.z = value;
                break;
            }
            case 2: {
                this.f = value;
                break;
            }
            case 64: {
                this.ext.s_ext = value;
                break;
            }
            case 128: {
                this.ext.s_bed = value;
                break;
            }
            case 32: {
                this.ext.s_fan = value;
                break;
            }
            case 512: {
                this.ext.ix = value;
                break;
            }
            case 1024: {
                this.ext.jy = value;
                break;
            }
            case 2048: {
                this.ext.kz = value;
                break;
            }
            case 256: {
                this.ext.r = value;
                break;
            }
        }
    }

    @Override
    public boolean isInitialized(int mask) {
        switch (mask) {
            case 1: {
                return this.e != Float.MAX_VALUE;
            }
            case 4: {
                return this.x != Float.MAX_VALUE;
            }
            case 8: {
                return this.y != Float.MAX_VALUE;
            }
            case 16: {
                return this.z != Float.MAX_VALUE;
            }
            case 2: {
                return this.f != Float.MAX_VALUE;
            }
            case 64: {
                return this.ext != null && this.ext.s_ext != Float.MAX_VALUE;
            }
            case 128: {
                return this.ext != null && this.ext.s_bed != Float.MAX_VALUE;
            }
            case 32: {
                return this.ext != null && this.ext.s_fan != Float.MAX_VALUE;
            }
            case 512: {
                return this.ext != null && this.ext.ix != Float.MAX_VALUE;
            }
            case 1024: {
                return this.ext != null && this.ext.jy != Float.MAX_VALUE;
            }
            case 2048: {
                return this.ext != null && this.ext.kz != Float.MAX_VALUE;
            }
            case 256: {
                return this.ext != null && this.ext.r != Float.MAX_VALUE;
            }
        }
        return false;
    }

    @Override
    protected void setUnit(String unit) {
        if (this.ext == null) {
            this.ext = new Extended();
        }
        this.ext.unit = unit;
    }

    private class Extended {
        private float ix = Float.MAX_VALUE;
        private float jy = Float.MAX_VALUE;
        private float kz = Float.MAX_VALUE;
        private float r = Float.MAX_VALUE;
        private float s_ext = Float.MAX_VALUE;
        private float s_bed = Float.MAX_VALUE;
        private float s_fan = Float.MAX_VALUE;
        private String unit = null;

        private Extended() {
        }
    }
}

