/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodes;

import de.dietzm.Constants;
import de.dietzm.Position;
import de.dietzm.gcodes.GCode;

public class GCodeZ
extends GCode {
    private float z = Float.MAX_VALUE;
    private float time;
    private float timeaccel;
    private float distance;
    private short fanspeed;

    @Override
    public short getFanspeed() {
        return this.fanspeed;
    }

    @Override
    public void setFanspeed(float fanspeed) {
        this.fanspeed = (short)fanspeed;
    }

    public GCodeZ(String line, int linenr, Constants.GCDEF gc) {
        super(line, linenr, gc);
    }

    public GCodeZ(String line, Constants.GCDEF gc) {
        super(line, 0, gc);
    }

    @Override
    public Position getCurrentPosition(Position pos) {
        return null;
    }

    @Override
    public float getDistance() {
        return this.distance;
    }

    @Override
    public float getE() {
        return 0.0f;
    }

    @Override
    public float getExtrusion() {
        return 0.0f;
    }

    @Override
    public float getF() {
        return 0.0f;
    }

    @Override
    public Position getPosition(Position reference) {
        return null;
    }

    @Override
    public float getSpeed() {
        return Constants.round2digits(this.distance / this.time);
    }

    protected String getIfInit(String prefix, float val, int digits, int mask) {
        if (!this.isInitialized(mask)) {
            return "";
        }
        if (digits == 0) {
            String var = String.format(" " + prefix + "%.1f", Float.valueOf(val));
            return Constants.removeTrailingZeros(var);
        }
        if ("E".equals(prefix) && val == 0.0f) {
            return " E0";
        }
        return String.format(" " + prefix + "%." + digits + "f", Float.valueOf(val));
    }

    @Override
    public float getTime() {
        return this.time;
    }

    @Override
    public String getUnit() {
        return null;
    }

    @Override
    protected void setUnit(String unit) {
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public boolean isExtrudeOrRetract() {
        return false;
    }

    @Override
    public void setCurrentPosition(Position currentPosition) {
    }

    @Override
    public void setDistance(float distance) {
        this.distance = distance;
    }

    @Override
    public void setExtrusion(float extrusion) {
    }

    @Override
    public void setTime(float time) {
        this.time = time;
    }

    @Override
    public void setTimeAccel(float time) {
        this.timeaccel = time;
    }

    @Override
    public float getTimeAccel() {
        return this.timeaccel;
    }

    @Override
    public float getExtrusionSpeed() {
        return 0.0f;
    }

    @Override
    public String toString() {
        String var = String.valueOf(this.lineindex) + ":  " + this.toStringRaw();
        var = String.valueOf(var) + "\tExtrusion:0";
        var = String.valueOf(var) + "\tDistance:" + this.distance;
        var = String.valueOf(var) + "\tPosition:0x0";
        var = String.valueOf(var) + "\tTime:" + this.time;
        return var;
    }

    @Override
    public String toCSV() {
        String var = String.valueOf(this.getSpeed());
        var = String.valueOf(var) + ";0";
        var = String.valueOf(var) + ";" + this.distance;
        var = String.valueOf(var) + ";" + this.time;
        var = String.valueOf(var) + ";" + this.fanspeed;
        return var;
    }

    @Override
    public void setInitialized(short mask, float value) {
        switch (mask) {
            case 16: {
                this.z = value;
                break;
            }
        }
    }

    @Override
    public boolean isInitialized(int mask) {
        switch (mask) {
            case 16: {
                return this.z != Float.MAX_VALUE;
            }
        }
        return false;
    }

    @Override
    public boolean isExtruding() {
        return false;
    }

    @Override
    public float getY() {
        return 0.0f;
    }

    @Override
    public float getR() {
        return 0.0f;
    }

    @Override
    public float getKz() {
        return 0.0f;
    }

    @Override
    public float getJy() {
        return 0.0f;
    }

    @Override
    public float getIx() {
        return 0.0f;
    }

    @Override
    public float getX() {
        return 0.0f;
    }

    @Override
    public float getS_Fan() {
        return 0.0f;
    }

    @Override
    public float getS_Ext() {
        return 0.0f;
    }

    @Override
    public float getS_Bed() {
        return 0.0f;
    }

    @Override
    public float getBedtemp() {
        return 0.0f;
    }

    @Override
    public float getExtemp() {
        return 0.0f;
    }
}

