/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodesim;

import de.dietzm.Constants;
import de.dietzm.Layer;
import de.dietzm.Model;
import de.dietzm.Position;
import de.dietzm.gcodes.GCode;
import de.dietzm.gcodes.MemoryEfficientLenString;
import de.dietzm.gcodes.MemoryEfficientString;
import de.dietzm.gcodesim.GraphicRenderer;
import de.dietzm.print.Printer;
import java.io.InputStream;
import java.util.ArrayList;

public class GcodePainter
implements Runnable {
    public int bedsizeX = 200;
    public int bedsizeY = 200;
    public int colNR = 7;
    public boolean painttravel = true;
    public boolean paintWhilePrint = true;
    public boolean oneLayerAtATime = false;
    private float fanspeed = 0.0f;
    private boolean useAccelTime = true;
    private boolean ffLayer = false;
    private int fftoGcode = 0;
    private int fftoLayer = 0;
    private float zoom = 3.5f;
    private Layer currentlayer = null;
    private float speedup = 5.0f;
    public static final float zoommod = 2.7f;
    private int pause = 0;
    private boolean inpause = false;
    private int Xoffset = 0;
    private int Yoffset = 0;
    private Thread gcodepainter;
    private String errormsg = null;
    private String[] modelspeed = null;
    private String[] modelcomments = null;
    private String[] modellaysum = null;
    private String[] modeldetails = null;
    private String speeduplabel = String.valueOf(this.speedup) + "x";
    private MemoryEfficientLenString tempbuf = new MemoryEfficientLenString(new byte[10]);
    private float mtime;
    private Printer printer = null;
    private ArrayList<Layer> layers;
    private GraphicRenderer g2;
    private Commands cmd = Commands.NOOP;
    private boolean print = false;
    private int inbuffer = 0;
    private int bufferemptyindex = 0;
    public Model model = null;
    public static final int gap = 20;
    int detailstype = 0;

    public boolean isPainttravel() {
        return this.painttravel;
    }

    public void setPainttravel(boolean painttravel) {
        this.painttravel = painttravel;
    }

    protected boolean isOneLayerAtATime() {
        return this.oneLayerAtATime;
    }

    public void setOneLayerAtATime(boolean oneLayerAtATime) {
        this.oneLayerAtATime = oneLayerAtATime;
    }

    public void setPaintWhilePrint(boolean paintWhilePrint) {
        this.paintWhilePrint = paintWhilePrint;
    }

    public float getZoom() {
        return this.zoom;
    }

    public Layer getCurrentLayer() {
        return this.currentlayer;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.setCmd(Commands.REPAINTLAYERS);
    }

    public synchronized void toggleSpeed(boolean faster, int steps) {
        this.speedup = faster ? (this.speedup + (float)steps > 99.0f ? 99.0f : (float)Math.round(this.speedup + (float)steps)) : ((double)(this.speedup - (float)steps) <= 0.1 ? 0.1f : (this.speedup -= (float)steps));
        this.updateSpeedupLabel();
        this.setCmd(Commands.REPAINTLABEL);
    }

    public synchronized void toggleSpeed(boolean faster) {
        if (faster && this.speedup >= 1.0f) {
            if (this.speedup >= 99.0f) {
                return;
            }
            this.speedup += 1.0f;
        } else if (faster && this.speedup < 1.0f) {
            this.speedup = (float)((double)this.speedup + 0.1);
        } else if (this.speedup > 1.0f) {
            this.speedup -= 1.0f;
        } else if (this.speedup > 0.1f) {
            this.speedup -= 0.1f;
        }
        this.updateSpeedupLabel();
        this.setCmd(Commands.REPAINTLABEL);
    }

    private void updateSpeedupLabel() {
        this.speeduplabel = this.speedup > 1.0f ? String.valueOf(this.speedup) + "x" : String.valueOf(Constants.round2digits(this.speedup)) + "x";
    }

    public synchronized void togglePause() {
        if (this.pause == 0) {
            this.pause = 999999;
        } else {
            this.pause = 0;
            if (this.inpause) {
                this.gcodepainter.interrupt();
            }
        }
    }

    public boolean isPause() {
        return this.pause != 0;
    }

    public synchronized void doStep(boolean forward) {
        if (forward) {
            if (this.pause != 0 && this.inpause) {
                this.gcodepainter.interrupt();
            } else {
                this.setCmd(Commands.STEP50X);
            }
        } else if (this.pause != 0 && this.inpause) {
            this.setCmd(Commands.STEPBACK);
        } else {
            this.setCmd(Commands.STEP50XBACK);
        }
    }

    public synchronized void togglePrint() {
        this.pause = 0;
        if (this.printer != null && !this.print) {
            this.setCmd(Commands.PRINT);
        } else {
            this.print = false;
            this.setCmd(Commands.RESTART);
        }
    }

    public synchronized void showHelp() {
        this.setCmd(Commands.HELP);
    }

    public synchronized void setCmd(Commands cmd) {
        if (this.print) {
            if (cmd == Commands.REPAINTLABEL) {
                this.cmd = cmd;
            }
            return;
        }
        if (this.gcodepainter != null) {
            this.gcodepainter.interrupt();
            this.cmd = cmd;
        }
    }

    public int[] getSize(boolean details) {
        return new int[]{(int)((float)this.bedsizeX * this.getZoom() + 20.0f + (details ? (float)this.bedsizeX * this.zoom / 2.7f * 2.0f : 0.0f) + 13.0f), (int)((float)this.bedsizeY * this.getZoom() + (float)this.bedsizeY * this.getZoom() / 12.0f + 65.0f)};
    }

    private void restart(final String filename) {
        this.model.getGcodes().clear();
        this.model.getLayer().clear();
        this.model = null;
        this.layers = null;
        System.gc();
        new Thread(new Runnable(){

            @Override
            public void run() {
                GcodePainter.this.start(filename, null, null);
            }
        }).start();
    }

    public synchronized void toggleType() {
        this.detailstype = this.detailstype < 7 ? ++this.detailstype : 0;
        this.setCmd(Commands.REPAINTLABEL);
    }

    public void setPrintercon(Printer printercon) {
        this.printer = printercon;
    }

    public GcodePainter(GraphicRenderer g) {
        this.g2 = g;
        this.colNR = g.getColorNr() - 2;
    }

    public GcodePainter(GraphicRenderer g, boolean modeldetails, float zoomlevel, int bedx, int bedy) {
        this(g);
        this.zoom = zoomlevel;
        this.bedsizeX = bedx;
        this.bedsizeY = bedy;
    }

    private void calculateOffset() {
        float midpoint;
        if (this.model.getBoundaries()[0] >= (float)this.bedsizeX || this.model.getBoundaries()[1] <= 0.0f) {
            midpoint = this.model.getBoundaries()[0] - this.model.getDimension()[0] / 2.0f;
            this.Xoffset = (int)((float)(this.bedsizeX / 2) - midpoint);
        } else {
            this.Xoffset = 0;
        }
        if (this.model.getBoundaries()[2] >= (float)this.bedsizeY || this.model.getBoundaries()[3] <= 0.0f) {
            midpoint = this.model.getBoundaries()[2] - this.model.getDimension()[1] / 2.0f;
            this.Yoffset = (int)((float)(this.bedsizeY / 2) - midpoint);
        } else {
            this.Yoffset = 0;
        }
    }

    private void paintLabel(GraphicRenderer g2, Layer lay, GCode gc) {
        if (gc == null) {
            this.printLabelBox(g2, 0, 12, Constants.inttoChar(lay.getNumber(), this.tempbuf), "Layer #", lay.getNumber());
            this.printLabelBox(g2, 12, 20, Constants.floattoChar(lay.getZPosition(), this.tempbuf, 2), "Z Position", lay.getNumber());
            this.printLabelBox(g2, 32, 12, "0", "XY Speed", lay.getNumber());
            this.printLabelBox(g2, 44, 14, "0", "E Speed", lay.getNumber());
            this.printLabelBox(g2, 95, 5, this.getFanSpeed(lay.getFanspeed()), "Fan", lay.getNumber());
        } else {
            this.printLabelBox(g2, 32, 12, Constants.inttoChar(Math.round(gc.getSpeed()), this.tempbuf), "XY Speed", lay.getNumber());
            this.printLabelBox(g2, 44, 14, this.getExtrSpeed(gc), "E Speed", lay.getNumber());
            if (gc.isInitialized(16)) {
                MemoryEfficientString cs = Constants.floattoChar(gc.getZ(), this.tempbuf, 2);
                this.printLabelBox(g2, 12, 20, cs, "Z Position", lay.getNumber());
            }
            this.printLabelBox(g2, 95, 5, this.getFanSpeed(gc.getFanspeed()), "Fan", lay.getNumber());
        }
        int nr = Constants.formatTimetoHHMMSS(this.mtime, this.tempbuf.getBytes());
        this.tempbuf.setlength(nr);
        this.printLabelBox(g2, 58, 24, this.tempbuf, "Remaining Time", lay.getNumber());
        if (this.print) {
            if (gc != null) {
                this.printLabelBox(g2, 81, 14, gc.getGcode().toString(), "Print", lay.getNumber());
            } else {
                this.printLabelBox(g2, 81, 14, "#", "Print", lay.getNumber());
            }
        } else {
            this.printLabelBox(g2, 81, 14, this.speeduplabel, "Speedup", lay.getNumber());
        }
    }

    private String getFanSpeed(float fanf) {
        if (fanf == 32767.0f) {
            fanf = this.fanspeed;
        } else {
            this.fanspeed = fanf;
        }
        if (fanf == 0.0f) {
            return "";
        }
        if (fanf < 100.0f) {
            return "I";
        }
        if (fanf < 200.0f) {
            return "II";
        }
        return "III";
    }

    private void printDetails(GraphicRenderer g2, Layer lay) {
        g2.setColor(lay.getNumber() % this.colNR);
        float boxheight = (float)this.bedsizeX * this.zoom / 12.0f;
        int linegap = (int)(4.0f * this.zoom + 3.2f);
        float size = 2.5f + 3.1f * this.zoom / 200.0f * (float)this.bedsizeX;
        g2.setFontSize(size);
        String[] det = null;
        int start = 0;
        switch (this.detailstype) {
            case 0: {
                det = this.modeldetails;
                break;
            }
            case 1: {
                StringBuilder tmpbuf = new StringBuilder();
                tmpbuf.append("--------------- Layer details ------------------\n");
                tmpbuf.append(lay.getLayerDetailReport());
                det = tmpbuf.toString().split("\n");
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                det = this.modellaysum;
                String[] lines = this.modellaysum;
                if ((float)(lines.length * linegap + 30) >= (float)this.bedsizeY * this.zoom + boxheight - (float)this.bedsizeY * this.zoom / 2.7f) {
                    start = (int)(((float)this.bedsizeY * this.zoom + boxheight - (float)linegap - (float)this.bedsizeY * this.zoom / 2.7f) / (float)linegap + 1.0f) * (this.detailstype - 2);
                    break;
                }
                this.detailstype = 5;
                det = null;
            }
            case 5: {
                det = this.modelspeed;
                break;
            }
            case 6: {
                det = lay.getLayerSpeedReport().split("\n");
                break;
            }
            case 7: {
                det = this.modelcomments;
                if (det.length != 0) break;
            }
            default: {
                det = this.modeldetails;
            }
        }
        g2.clearrect((float)this.bedsizeX * this.zoom + 20.0f + 5.0f, (float)this.bedsizeY * this.zoom / 2.7f + 2.0f, (float)this.bedsizeX * this.zoom / 2.7f * 2.0f - 5.0f, (float)this.bedsizeY * this.zoom + boxheight - (float)this.bedsizeY * this.zoom / 2.7f - 7.0f, this.print ? 1 : 0);
        int c = 0;
        int i = start;
        while (i < det.length) {
            int y = (int)((float)this.bedsizeY * this.zoom / 2.7f) + linegap + c * linegap;
            ++c;
            if ((float)(y + 30) >= (float)this.bedsizeY * this.zoom + boxheight) break;
            g2.drawtext(det[i], (float)this.bedsizeX * this.zoom + 20.0f + 5.0f, y);
            ++i;
        }
    }

    private void printLabelBox(GraphicRenderer g2, int boxposp, int bsizepercent, CharSequence value, CharSequence labl, int laynr) {
        float boxsize = ((float)this.bedsizeX * this.zoom + 20.0f) / 100.0f * (float)bsizepercent;
        float boxpos = ((float)this.bedsizeX * this.zoom + 20.0f) / 100.0f * (float)boxposp;
        float boxheight = (float)this.bedsizeX * this.zoom / 12.0f;
        float gapz = this.zoom;
        float size = 10.15f * this.zoom / 200.0f * (float)this.bedsizeX;
        g2.clearrect(boxpos + 2.0f, (float)this.bedsizeY * this.zoom + 2.0f, boxsize - 3.0f, boxheight - 2.0f, this.print ? 1 : 0);
        g2.setColor(this.colNR);
        g2.drawrect(boxpos, (float)this.bedsizeY * this.zoom, boxsize, boxheight + 1.0f);
        g2.setColor(laynr % this.colNR);
        g2.setFontSize(size);
        g2.drawtext(value, boxpos, (float)this.bedsizeY * this.zoom + size - gapz, boxsize);
        g2.setFontSize(size / 3.0f);
        g2.drawtext(labl, boxpos, (float)this.bedsizeY * this.zoom + boxheight - gapz * 2.0f, boxsize);
    }

    private void paintLoading(GraphicRenderer g) {
        g.setColor(this.colNR);
        g.setFontSize(40.0f);
        g.drawtext("Please Wait", 100.0f, 200.0f);
        g.drawtext("Loading Model......", 100.0f, 270.0f);
        if (this.model != null) {
            g.clearrect(200.0f, 285.0f, 500.0f, 75.0f, this.print ? 1 : 0);
            if (this.errormsg != null) {
                g.setFontSize(20.0f);
                String[] errlines = this.errormsg.split("\n");
                int i = 0;
                while (i < errlines.length) {
                    g.drawtext(errlines[i], 100.0f, 340 + i * 30);
                    ++i;
                }
            } else if (this.model.getFilesize() > 0L) {
                g.drawtext(String.valueOf(Constants.round2digits((float)this.model.getReadbytes() / ((float)this.model.getFilesize() / 100.0f))) + "%  (" + this.model.getGcodes().size() + ")", 220.0f, 340.0f);
            } else {
                g.drawtext(String.valueOf(this.model.getGcodes().size()), 220.0f, 340.0f);
            }
        }
        g.setFontSize(11.5f);
    }

    private void paintHelp(GraphicRenderer g) {
        g.setColor(0);
        float boxsize = (float)this.bedsizeX * this.zoom / 2.5f;
        float xbox = (float)this.bedsizeX * this.zoom / 2.0f - boxsize / 2.0f;
        float ybox = (float)this.bedsizeY * this.zoom / 2.0f - boxsize / 2.0f;
        g.fillrect(xbox, ybox, boxsize + 30.0f, boxsize + 109.0f);
        g.drawrect(xbox - 3.0f, ybox - 3.0f, boxsize + 36.0f, boxsize + 115.0f);
        float gap = 5.0f * this.zoom;
        g.setColor(this.colNR);
        this.g2.drawtext("Gcode Simulator v1.18", xbox + 3.0f, ybox + gap);
        this.g2.drawtext("________________________", xbox + 3.0f, ybox + gap + 1.0f);
        this.g2.drawtext("Author: Mathias Dietz ", xbox + 3.0f, ybox + gap * 2.0f);
        this.g2.drawtext("Contact: gcode@dietzm.de ", xbox + 3.0f, ybox + gap * 3.0f);
        this.g2.drawtext("Key Shortcuts Help: ", xbox + 3.0f, ybox + gap * 4.0f + 3.0f);
        this.g2.drawtext("________________________", xbox + 3.0f, ybox + gap * 4.0f + 4.0f);
        this.g2.drawtext("+/- = Speed up/down", xbox + 3.0f, ybox + gap * 5.0f);
        this.g2.drawtext("//* = 10x Speed up/down", xbox + 3.0f, ybox + gap * 6.0f);
        this.g2.drawtext("i/o = Zoom in/out", xbox + 3.0f, ybox + gap * 7.0f);
        this.g2.drawtext("n/b = Layer next/back", xbox + 3.0f, ybox + gap * 8.0f);
        this.g2.drawtext("m   = Show Model Details", xbox + 3.0f, ybox + gap * 9.0f);
        this.g2.drawtext("t   = Toggle Model Details", xbox + 3.0f, ybox + gap * 10.0f);
        this.g2.drawtext("f   = Load Gcode File", xbox + 3.0f, ybox + gap * 11.0f);
        this.g2.drawtext("p/r/q = Pause / Restart / Quit", xbox + 3.0f, ybox + gap * 12.0f);
        this.g2.drawtext("space/backspace = Fast forward/back", xbox + 3.0f, ybox + gap * 13.0f);
        this.g2.drawtext("space/backspace = Step forward/back (Pause)", xbox + 3.0f, ybox + gap * 14.0f);
        this.g2.drawtext("Mouse Shortcuts Help: ", xbox + 3.0f, ybox + gap * 15.0f + 3.0f);
        this.g2.drawtext("________________________", xbox + 3.0f, ybox + gap * 15.0f + 4.0f);
        this.g2.drawtext("Mousewheel = Speed up/down", xbox + 3.0f, ybox + gap * 16.0f);
        this.g2.drawtext("ALT+Mousewheel = Zoom in/out", xbox + 3.0f, ybox + gap * 17.0f);
        this.g2.drawtext("Left Button on Bed = Next Layer", xbox + 3.0f, ybox + gap * 18.0f);
        this.g2.drawtext("ALT+Left Button on Bed = Previous Layer", xbox + 3.0f, ybox + gap * 19.0f);
        this.g2.drawtext("Right Button = Show Model Details", xbox + 3.0f, ybox + gap * 20.0f);
        this.g2.drawtext("Left Button on Details = Toggle Model Details", xbox + 3.0f, ybox + gap * 21.0f);
        this.g2.drawtext("Middle Button = Show Help", xbox + 3.0f, ybox + gap * 22.0f);
    }

    private void printBed(GraphicRenderer g2) {
        g2.setColor(this.colNR);
        g2.drawrect(0.0f, 0.0f, (float)this.bedsizeX * this.zoom, (float)this.bedsizeY * this.zoom);
        g2.drawrect((float)this.bedsizeX * this.zoom, 0.0f, 20.0f, (float)this.bedsizeY * this.zoom);
        float zoomsmall = this.zoom / 2.7f;
        g2.drawrect((float)this.bedsizeX * this.zoom + 20.0f, 0.0f, (float)this.bedsizeX * zoomsmall, (float)this.bedsizeY * zoomsmall);
        g2.drawrect((float)this.bedsizeX * this.zoom + 20.0f + (float)this.bedsizeX * zoomsmall, 0.0f, (float)this.bedsizeX * zoomsmall, (float)this.bedsizeY * zoomsmall);
        float boxheight = (float)this.bedsizeX * this.zoom / 12.0f;
        g2.drawrect((float)this.bedsizeX * this.zoom + 20.0f, 0.0f, (float)this.bedsizeX * zoomsmall * 2.0f, (float)this.bedsizeY * this.zoom + boxheight + 1.0f);
        float fsize = 2.0f + 5.0f * this.zoom / 200.0f * (float)this.bedsizeX;
        g2.setFontSize(fsize);
        g2.drawtext("Front View", (float)this.bedsizeX * this.zoom + 20.0f + (float)this.bedsizeX * zoomsmall, fsize + 2.0f, (float)this.bedsizeX * zoomsmall);
        g2.drawtext("Side View", (float)this.bedsizeX * this.zoom + 20.0f, fsize + 2.0f, (float)this.bedsizeX * zoomsmall);
        g2.setStroke(2);
        g2.setColor(this.colNR + 1);
        int i = 10;
        while (i < this.bedsizeX) {
            g2.drawline((float)i * this.zoom, 0.0f, (float)i * this.zoom, (float)this.bedsizeY * this.zoom);
            g2.drawline(0.0f, (float)i * this.zoom, (float)this.bedsizeX * this.zoom, (float)i * this.zoom);
            i += 10;
        }
        g2.drawline((float)this.bedsizeX * this.zoom + 20.0f, (float)this.bedsizeY * zoomsmall, (float)this.bedsizeX * this.zoom + 20.0f + 60.0f, (float)this.bedsizeY * zoomsmall - 60.0f);
        g2.drawline((float)this.bedsizeX * this.zoom + 20.0f + (float)this.bedsizeX * zoomsmall, (float)this.bedsizeY * zoomsmall, (float)this.bedsizeX * this.zoom + 20.0f + (float)this.bedsizeX * zoomsmall - 60.0f, (float)this.bedsizeY * zoomsmall - 60.0f);
        if (this.Xoffset != 0 || this.Yoffset != 0) {
            g2.setStroke(0);
            g2.setColor(this.colNR);
            g2.drawline((float)this.Xoffset * this.zoom - 10.0f, (float)this.Yoffset * this.zoom, (float)this.Xoffset * this.zoom + 100.0f, (float)this.Yoffset * this.zoom);
            g2.drawline((float)this.Xoffset * this.zoom, (float)this.Yoffset * this.zoom + 10.0f, (float)this.Xoffset * this.zoom, (float)this.Yoffset * this.zoom - 100.0f);
            g2.setStroke(1);
        }
    }

    private void paintLevelBar(GraphicRenderer g2, Layer lay) {
        g2.setStroke(1);
        g2.setColor(lay.getNumber() % this.colNR);
        float factor = ((float)this.bedsizeY * this.zoom - 2.0f) / (this.model.getDimension()[2] * 10.0f);
        g2.fillrect((float)this.bedsizeX * this.zoom, (float)this.bedsizeY * this.zoom - (float)((int)(lay.getZPosition() * 10.0f * factor)), 20.0f, (int)(lay.getLayerheight() * 10.0f * factor));
    }

    private float printLine(GraphicRenderer g2, Position lastpos, Position pos, float zpos, float time, long starttime, boolean travel) {
        float x1 = (lastpos.x + (float)this.Xoffset) * this.zoom;
        float y1 = (float)this.bedsizeY * this.zoom - (lastpos.y + (float)this.Yoffset) * this.zoom;
        float x2 = (pos.x + (float)this.Xoffset) * this.zoom;
        float y2 = (float)this.bedsizeY * this.zoom - (pos.y + (float)this.Yoffset) * this.zoom;
        if (!this.ffLayer && this.fftoGcode == 0 && this.fftoLayer == 0 && this.speedup < 10.0f) {
            float distx = x2 - x1;
            float disty = y2 - y1;
            int maxdist = (int)Math.max(Math.abs(distx), Math.abs(disty)) / 5;
            if (maxdist > 5) {
                float stepx = distx / (float)maxdist;
                float stepy = disty / (float)maxdist;
                int i = 0;
                while (i < maxdist) {
                    float nx = x1 + (float)(i + 1) * stepx;
                    float lx = x1 + (float)i * stepx;
                    float ly = y1 + (float)i * stepy;
                    float ny = y1 + (float)(i + 1) * stepy;
                    g2.setPos((int)lx, (int)ny);
                    g2.drawline(lx, ly, nx, ny);
                    this.printLineHorizontal2(g2, lx, ly, nx, ny, zpos, travel);
                    try {
                        g2.repaint();
                        long paintdur = System.currentTimeMillis() - starttime;
                        long sleepremain = Math.max(0L, (long)time - paintdur);
                        long dosleep = Math.min(sleepremain, (long)(time / (float)maxdist));
                        Thread.sleep(dosleep);
                    }
                    catch (InterruptedException e) {
                        time = 0.0f;
                    }
                    ++i;
                }
                return 0.0f;
            }
        }
        g2.drawline(x1, y1, x2, y2);
        this.printLineHorizontal2(g2, x1, y1, x2, y2, zpos, travel);
        return time;
    }

    private float printArc(GraphicRenderer g2, Position lastpos, Position pos, Layer lay, GCode gc) {
        double angle2;
        double angle1;
        float cx = lastpos.x + gc.getIx();
        float cy = lastpos.y + gc.getJy();
        float bx = pos.x - cx;
        float by = pos.y - cy;
        float ax = lastpos.x - cx;
        float ay = lastpos.y - cy;
        float xmove = Math.abs(cx - lastpos.x);
        float ymove = Math.abs(cy - lastpos.y);
        float radius = (float)Math.sqrt(xmove * xmove + ymove * ymove);
        if (gc.getGcode() == Constants.GCDEF.G2) {
            angle1 = Math.atan2(by, bx) * 57.29577951308232;
            angle2 = Math.atan2(ay, ax) * 57.29577951308232;
        } else {
            angle2 = Math.atan2(by, bx) * 57.29577951308232;
            angle1 = Math.atan2(ay, ax) * 57.29577951308232;
        }
        double angle = (int)(angle2 - angle1);
        float utx = cx - radius;
        float uty = cy + radius;
        g2.drawArc((int)((utx + (float)this.Xoffset) * this.zoom), (int)((float)this.bedsizeY * this.zoom - (uty + (float)this.Yoffset) * this.zoom), (int)(radius * 2.0f * this.zoom), (int)(radius * 2.0f * this.zoom), (int)angle1, (int)angle);
        return 0.0f;
    }

    private void printLineHorizontal(GraphicRenderer g2, Position lastpos, Position pos, float zpos) {
        float zoomsmall = this.zoom / 2.7f;
        float z = (float)this.bedsizeY * zoomsmall - zpos * zoomsmall - 20.0f;
        float y1 = (float)this.bedsizeX * zoomsmall - (lastpos.y + (float)this.Yoffset) * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f);
        float y2 = (float)this.bedsizeX * zoomsmall - (pos.y + (float)this.Yoffset) * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f);
        g2.drawline(y1, z, y2, z);
        float x1 = (lastpos.x + (float)this.Xoffset) * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f) + (float)this.bedsizeX * zoomsmall;
        float x2 = (pos.x + (float)this.Xoffset) * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f) + (float)this.bedsizeX * zoomsmall;
        g2.drawline(x1, z, x2, z);
        g2.setPos((int)y1, (int)x1, (int)z);
    }

    private void printLineHorizontal2(GraphicRenderer g2, float lx, float ly, float x, float y, float zpos, boolean travel) {
        float zoomsmall = this.zoom / 2.7f;
        float z = (float)this.bedsizeY * zoomsmall - zpos * zoomsmall - 20.0f;
        float y1 = (float)this.bedsizeX * zoomsmall - ly / this.zoom * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f);
        float y2 = (float)this.bedsizeX * zoomsmall - y / this.zoom * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f);
        float x1 = lx / this.zoom * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f) + (float)this.bedsizeX * zoomsmall;
        float x2 = x / this.zoom * zoomsmall + ((float)this.bedsizeX * this.zoom + 20.0f) + (float)this.bedsizeX * zoomsmall;
        if (!travel) {
            g2.drawline(y1, z, y2, z);
            g2.drawline(x1, z, x2, z);
        }
        g2.setPos((int)y1, (int)x1, (int)z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("GcodePainter");
        this.g2.clearrect(0.0f, 0.0f, this.g2.getWidth(), this.g2.getHeight(), this.print ? 1 : 0);
        this.g2.repaint();
        block9: while (true) {
            if (this.layers != null) {
                if (this.model.getGcodecount() < 50) {
                    this.pause = 999999;
                }
                Position pos = new Position(0.0f, 0.0f);
                Position lastpos = new Position(0.0f, 0.0f);
                this.fanspeed = 0.0f;
                this.updateDetailLabels();
                this.updateSpeedupLabel();
                this.g2.clearrect(0.0f, 0.0f, this.g2.getWidth(), this.g2.getHeight(), this.print ? 1 : 0);
                this.calculateOffset();
                this.mtime = this.model.getTimeaccel();
                this.printBed(this.g2);
                if (this.print) {
                    this.g2.setTitle("Print Mode");
                } else {
                    this.g2.setTitle("Simulation");
                }
                for (Layer lay : this.layers) {
                    if (this.oneLayerAtATime) {
                        this.g2.clearrect(2.0f, 2.0f, (float)this.bedsizeX * this.zoom - 2.0f, (float)this.bedsizeY * this.zoom, this.print ? 1 : 0);
                        this.printBed(this.g2);
                    } else if (this.fftoLayer == 0 || this.fftoLayer <= lay.getNumber() + 10) {
                        this.g2.faintRect(2.0f, 2.0f, (float)this.bedsizeX * this.zoom + 20.0f, (float)this.bedsizeY * this.zoom);
                    }
                    this.currentlayer = lay;
                    this.ffLayer = false;
                    this.printDetails(this.g2, lay);
                    this.paintLevelBar(this.g2, lay);
                    this.paintLabel(this.g2, lay, null);
                    ArrayList<GCode> gcarr = lay.getGcodes();
                    int gcnum = gcarr.size();
                    float zpos = lay.getZPosition();
                    int ig = 0;
                    while (ig < gcnum) {
                        GCode gCode = gcarr.get(ig);
                        Constants.GCDEF gcdef = gCode.getGcode();
                        if (gcdef != Constants.GCDEF.UNKNOWN && gcdef != Constants.GCDEF.COMMENT) {
                            long starttime = System.currentTimeMillis();
                            float sleeptime = 0.0f;
                            GraphicRenderer graphicRenderer = this.g2;
                            synchronized (graphicRenderer) {
                                if (!this.ffLayer && this.fftoGcode == 0 && this.fftoLayer == 0) {
                                    this.paintLabel(this.g2, lay, gCode);
                                    sleeptime = (this.useAccelTime ? gCode.getTimeAccel() : gCode.getTime()) * 1000.0f / this.speedup;
                                }
                            }
                            this.alignWithPrint(lay, gCode);
                            if (gCode.getCurrentPosition(pos) != null) {
                                this.g2.setPos((int)((pos.x + (float)this.Xoffset) * this.zoom), (int)((float)this.bedsizeY * this.zoom - (pos.y + (float)this.Yoffset) * this.zoom));
                                if (lastpos != null) {
                                    if (gCode.isExtruding()) {
                                        this.g2.setColor(lay.getNumber() % this.colNR);
                                        if (gcdef == Constants.GCDEF.G2 || gcdef == Constants.GCDEF.G3) {
                                            this.printArc(this.g2, lastpos, pos, lay, gCode);
                                            this.printLineHorizontal(this.g2, lastpos, pos, zpos);
                                        } else {
                                            this.printLine(this.g2, lastpos, pos, zpos, sleeptime, starttime, false);
                                        }
                                    } else if (this.painttravel) {
                                        this.g2.setColor(this.colNR + 1);
                                        this.g2.setStroke(0);
                                        if (gcdef == Constants.GCDEF.G2 || gcdef == Constants.GCDEF.G3) {
                                            this.printArc(this.g2, lastpos, pos, lay, gCode);
                                        } else {
                                            this.printLine(this.g2, lastpos, pos, zpos, sleeptime, starttime, true);
                                        }
                                        this.g2.setStroke(1);
                                    }
                                }
                            }
                            this.mtime -= gCode.getTimeAccel();
                            lastpos.updatePos(pos);
                            try {
                                int skip = this.handleCommand(gCode, lay);
                                if (skip == 1) continue block9;
                                if (skip == 2) {
                                    return;
                                }
                                if (!this.ffLayer && this.fftoGcode == 0 && this.fftoLayer == 0) {
                                    this.g2.repaint();
                                    long paintdur = System.currentTimeMillis() - starttime;
                                    long sleep = Math.max(0L, (long)sleeptime - paintdur);
                                    Thread.sleep((int)sleep);
                                    if (this.pause != 0) {
                                        this.doPause(lay, gCode);
                                    }
                                } else {
                                    if (this.fftoGcode != 0 && this.fftoGcode == gCode.getLineindex()) {
                                        this.fftoGcode = 0;
                                    }
                                    if (this.fftoLayer != 0 && this.fftoLayer == lay.getNumber()) {
                                        this.fftoLayer = 0;
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                this.inpause = false;
                                this.g2.clearrect((float)this.bedsizeX * this.zoom + 20.0f + 1.0f, (float)this.bedsizeY * this.zoom + (float)this.bedsizeX * this.zoom / 24.0f, (float)this.bedsizeX * this.zoom / 2.7f * 2.0f - 2.0f, (float)this.bedsizeX * this.zoom / 24.0f, this.print ? 1 : 0);
                            }
                        }
                        ++ig;
                    }
                }
            } else {
                this.g2.setTitle(null);
                this.g2.setPos(0, 0);
                this.paintLoading(this.g2);
                if (this.cmd == Commands.EXIT) {
                    this.cmd = Commands.NOOP;
                    return;
                }
                this.g2.repaint();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.print) continue;
            System.out.println("Print finished.");
            try {
                this.pause = 999999;
                this.g2.setFontSize(40.0f);
                this.g2.drawtext("Print Completed", 100.0f, 200.0f);
                this.inpause = true;
                this.togglePrint();
                this.g2.repaint();
                Thread.sleep(this.pause);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.inpause = false;
        }
    }

    private void updateDetailLabels() {
        StringBuilder tmpbuf = new StringBuilder();
        tmpbuf.append("--------------- Model details ------------------\n");
        tmpbuf.append(this.model.getModelDetailReport());
        tmpbuf.append(this.model.guessPrice(this.model.guessDiameter()));
        this.modeldetails = tmpbuf.toString().split("\n");
        this.modelspeed = this.model.getModelSpeedReport().split("\n");
        this.modelcomments = this.model.getModelComments().split("\n");
        this.modellaysum = this.model.getModelLayerSummaryReport().split("\n");
    }

    private void alignWithPrint(Layer lay, GCode renderCode) {
        if (this.printer == null || !this.printer.isPrinting() && !this.print) {
            return;
        }
        if (this.pause == 0 && this.printer.isPause()) {
            this.togglePause();
        }
        if (!this.print && this.printer.isPrinting()) {
            this.togglePrint();
            this.speedup = 1.0f;
        }
        int defbuffersize = 15;
        int maxbehind = 35;
        int behind = defbuffersize + 10;
        while (this.print && this.printer.isPrinting()) {
            try {
                if (!this.paintWhilePrint) {
                    if (this.model.getLayercount(false) > 2 && lay.getNumber() < 2) {
                        this.fftoLayer = 2;
                        return;
                    }
                    this.printLabelBox(this.g2, 82, 12, "W", "Wait", lay.getNumber());
                    this.g2.repaint();
                    while (this.printer.isPrinting()) {
                        Thread.sleep(2500L);
                    }
                }
                boolean wait = false;
                GCode printCode = this.printer.getCurrentGCode();
                if (printCode == null) continue;
                this.inbuffer = Math.min(defbuffersize, printCode.getLineindex() - this.bufferemptyindex);
                if (printCode.isBuffered() && renderCode.getLineindex() >= printCode.getLineindex() - this.inbuffer) {
                    wait = true;
                    this.speedup = 1.0f;
                } else if (!printCode.isBuffered() && renderCode.getLineindex() >= printCode.getLineindex()) {
                    wait = true;
                    this.bufferemptyindex = printCode.getLineindex();
                    this.speedup = 1.0f;
                }
                if (renderCode.getLineindex() < printCode.getLineindex() - maxbehind) {
                    this.fftoGcode = printCode.isBuffered() ? printCode.getLineindex() - this.inbuffer : printCode.getLineindex();
                    wait = false;
                } else if (renderCode.getLineindex() < printCode.getLineindex() - behind) {
                    this.speedup += 1.0f;
                    wait = false;
                }
                if (this.pause != 0) {
                    this.bufferemptyindex = printCode.getLineindex();
                    this.doPause(lay, renderCode);
                    this.printLabelBox(this.g2, 82, 12, "W", "Wait", lay.getNumber());
                    this.g2.repaint();
                    continue;
                }
                if (!wait) break;
                this.g2.repaint();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.printLabelBox(this.g2, 82, 12, "W", "Wait", lay.getNumber());
                this.g2.repaint();
            }
        }
        if (this.print && !this.printer.isPrinting()) {
            this.togglePrint();
        }
    }

    private void doPause(Layer lay, GCode gCode) throws InterruptedException {
        this.inpause = true;
        this.printLabelBox(this.g2, 82, 12, "P", "Pause", lay.getNumber());
        this.g2.clearrect((float)this.bedsizeX * this.zoom + 20.0f + 1.0f, (float)this.bedsizeY * this.zoom + (float)this.bedsizeX * this.zoom / 24.0f, (float)this.bedsizeX * this.zoom / 2.7f * 2.0f - 2.0f, (float)this.bedsizeX * this.zoom / 24.0f, this.print ? 1 : 0);
        this.g2.drawrect((float)this.bedsizeX * this.zoom + 20.0f + 4.0f, (float)this.bedsizeY * this.zoom + (float)this.bedsizeX * this.zoom / 24.0f + 2.0f, (float)this.bedsizeX * this.zoom / 2.7f * 2.0f - 7.0f, (float)this.bedsizeX * this.zoom / 24.0f - 5.0f);
        this.g2.drawtext("L" + gCode.getLineindex() + ": " + gCode.getCodeline().toString().trim(), (float)this.bedsizeX * this.zoom + 20.0f + 10.0f, (float)this.bedsizeY * this.zoom + (float)this.bedsizeX * this.zoom / 24.0f + (float)this.bedsizeX * this.zoom / 48.0f + 1.0f);
        this.g2.repaint();
        Thread.sleep(this.pause);
        this.inpause = false;
    }

    private CharSequence getExtrSpeed(GCode gCode) {
        int exspeed = Math.round(gCode.getExtrusionSpeed());
        String exvar = exspeed >= 0 ? Constants.inttoChar(exspeed, this.tempbuf) : "R";
        return exvar;
    }

    private synchronized int handleCommand(GCode gCode, Layer lay) {
        if (this.cmd == Commands.NOOP) {
            return 0;
        }
        Thread.interrupted();
        switch (this.cmd) {
            case EXIT: {
                this.cmd = Commands.NOOP;
                this.layers = null;
                return 2;
            }
            case OPENFILE: {
                this.cmd = Commands.NOOP;
                String file = this.g2.browseFileDialog();
                if (file == null) break;
                lay = null;
                gCode = null;
                this.layers = null;
                this.restart(file);
                return 2;
            }
            case NEXTLAYER: {
                this.cmd = Commands.NOOP;
                this.ffLayer = true;
                break;
            }
            case NEXTLAYER10: {
                this.cmd = Commands.NOOP;
                if (this.model.getLayercount(true) <= lay.getNumber() + 10) {
                    this.fftoLayer = this.model.getLayercount(true);
                    break;
                }
                this.fftoLayer = lay.getNumber() + 10;
                break;
            }
            case PREVIOUSLAYER: {
                this.cmd = Commands.NOOP;
                if (this.fftoLayer == 0) {
                    this.fftoLayer = lay.getNumber() - 1;
                    if (this.fftoLayer <= 0) {
                        this.fftoLayer = this.model.getLayercount(true);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 1;
            }
            case DEBUG: {
                this.cmd = Commands.NOOP;
                System.out.println(gCode);
                break;
            }
            case PRINT: {
                this.print = true;
            }
            case RESTART: {
                this.cmd = Commands.NOOP;
                this.g2.clearrect(0.0f, 0.0f, this.g2.getWidth(), this.g2.getHeight(), this.print ? 1 : 0);
                this.g2.repaint();
                return 1;
            }
            case REANALYSE: {
                this.cmd = Commands.NOOP;
                this.model = new Model(this.model.getFilename(), this.model.getGcodes());
                this.model.analyze();
                this.fftoLayer = lay.getNumber();
                this.g2.clearrect(0.0f, 0.0f, this.g2.getWidth(), this.g2.getHeight(), this.print ? 1 : 0);
                this.g2.repaint();
                return 1;
            }
            case REPAINTLABEL: {
                this.cmd = Commands.NOOP;
                this.paintLabel(this.g2, lay, gCode);
                this.printDetails(this.g2, lay);
                break;
            }
            case HELP: {
                this.cmd = Commands.NOOP;
                this.paintHelp(this.g2);
                this.g2.repaint();
                try {
                    this.wait(99999L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case REPAINTLAYERS: {
                this.cmd = Commands.NOOP;
                if (this.fftoGcode == 0) {
                    this.fftoGcode = gCode.getLineindex();
                }
                return 1;
            }
            case STEPBACK: {
                this.cmd = Commands.NOOP;
                if (this.fftoGcode == 0 && gCode.getLineindex() > 3) {
                    this.fftoGcode = gCode.getLineindex() - 3;
                }
                return 1;
            }
            case STEP50X: {
                this.cmd = Commands.NOOP;
                if (this.fftoGcode == 0 && gCode.getLineindex() < this.model.getGcodecount() - 50) {
                    this.fftoGcode = gCode.getLineindex() + 50;
                }
                return 1;
            }
            case STEP50XBACK: {
                this.cmd = Commands.NOOP;
                if (this.fftoGcode == 0 && gCode.getLineindex() > 50) {
                    this.fftoGcode = gCode.getLineindex() - 50;
                }
                return 1;
            }
        }
        return 0;
    }

    public void start(String filename, InputStream in, Model modelin) {
        if (this.gcodepainter != null) {
            this.errormsg = null;
            this.setCmd(Commands.EXIT);
            try {
                this.gcodepainter.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setCmd(Commands.NOOP);
            this.layers = null;
            this.model = null;
            this.g2.repaint();
        }
        this.gcodepainter = new Thread(this);
        this.gcodepainter.start();
        if (modelin == null) {
            boolean ret;
            try {
                this.model = new Model(filename);
                ret = false;
                ret = in == null ? this.model.loadModel() : this.model.loadModel(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errormsg = "Failed to load model. Is this a valid gcode file ?\n" + e.getMessage();
                this.g2.repaint();
                return;
            }
            if (!ret) {
                this.errormsg = "Failed to load model.Check errors on command line.";
                this.g2.repaint();
                return;
            }
            this.model.analyze();
        } else {
            this.model = modelin;
        }
        this.layers = new ArrayList<Layer>(this.model.getLayer());
    }

    public static enum Commands {
        STEPBACK,
        STEP50X,
        STEP50XBACK,
        RESTART,
        NEXTLAYER,
        NEXTLAYER10,
        REPAINTLABEL,
        DEBUG,
        EXIT,
        OPENFILE,
        NOOP,
        PRINT,
        REPAINTLAYERS,
        PREVIOUSLAYER,
        HELP,
        REANALYSE;

    }
}

