/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.print;

import de.dietzm.Model;
import de.dietzm.gcodes.GCode;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class PrintQueue
implements Runnable {
    public static final int MAX_MANUAL_CONCURRENT = 2000;
    public Model printModel = null;
    private float remainingtime = 0.0f;
    Thread addmodelth = null;
    private LinkedBlockingQueue<GCode> aprintQ = new LinkedBlockingQueue();
    private LinkedBlockingQueue<GCode> mprintQ = new LinkedBlockingQueue(2000);
    GCode[] postgc = null;

    public Model getPrintModel() {
        return this.printModel;
    }

    public void put(GCode code) throws InterruptedException {
        this.mprintQ.put(code);
    }

    public void putAuto(GCode code) throws InterruptedException {
        this.aprintQ.put(code);
        this.remainingtime += code.getTimeAccel();
    }

    public void addModel(Model code) throws InterruptedException {
        this.printModel = code;
        this.addmodelth = new Thread(this);
        this.addmodelth.start();
    }

    public void addModel(Model code, GCode ... postcodes) throws InterruptedException {
        this.printModel = code;
        this.postgc = postcodes;
        this.addmodelth = new Thread(this);
        this.addmodelth.start();
    }

    private synchronized void addModeltoQueue() {
        for (GCode gc : this.printModel.getGcodes()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!gc.isPrintable()) continue;
            this.aprintQ.add(gc);
        }
        if (this.postgc != null) {
            int i = 0;
            while (i < this.postgc.length) {
                this.aprintQ.add(this.postgc[i]);
                ++i;
            }
        }
        this.remainingtime = this.printModel.getTimeaccel();
    }

    public GCode pollManual(int timeout_sec) throws InterruptedException {
        GCode gc = this.mprintQ.poll(timeout_sec, TimeUnit.SECONDS);
        return gc;
    }

    public int getSizeAuto() {
        return this.aprintQ.size();
    }

    public int getSizeManual() {
        return this.mprintQ.size();
    }

    public boolean isManualEmpty() {
        return this.mprintQ.isEmpty();
    }

    public GCode pollAuto() throws InterruptedException {
        if (!this.mprintQ.isEmpty()) {
            return this.pollManual(1000);
        }
        GCode gc = null;
        int i = 0;
        do {
            if ((gc = this.aprintQ.poll(2L, TimeUnit.SECONDS)) != null) {
                this.remainingtime -= gc.getTimeAccel();
                return gc;
            }
            System.out.println("Still filling printqueue, retry");
        } while (this.isFillingQueue() && ++i < 5);
        return gc;
    }

    public void clear() {
        if (this.isFillingQueue()) {
            this.addmodelth.interrupt();
        }
        this.aprintQ.clear();
        this.mprintQ.clear();
        this.printModel = null;
        this.remainingtime = 0.0f;
    }

    public float getRemainingtime() {
        return this.remainingtime;
    }

    public int getPercentCompleted() {
        if (this.printModel.getGcodecount() / 100 == 0) {
            return 100;
        }
        if (this.aprintQ.size() == 0) {
            return 100;
        }
        int perc = 100 - this.aprintQ.size() / (this.printModel.getGcodecount() / 100);
        return perc;
    }

    @Override
    public void run() {
        try {
            this.addModeltoQueue();
            System.out.println("Model added. Finish filling thread. Intr:" + this.addmodelth.isInterrupted());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isFillingQueue() {
        return this.addmodelth != null && this.addmodelth.isAlive();
    }
}

