/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.print;

import de.dietzm.Constants;
import de.dietzm.Model;
import de.dietzm.gcodes.GCode;
import de.dietzm.gcodes.GCodeFactory;
import de.dietzm.gcodes.MemoryEfficientLenString;
import de.dietzm.gcodes.MemoryEfficientString;
import de.dietzm.print.ConsoleIf;
import de.dietzm.print.PrintQueue;
import de.dietzm.print.Printer;
import de.dietzm.print.PrinterConnection;
import de.dietzm.print.ReceiveBuffer;
import java.util.ArrayList;
import java.util.Date;

public class SerialPrinter
implements Runnable,
Printer {
    public static final GCode G0 = GCodeFactory.getGCode("G0", 0);
    public static final GCode M105 = GCodeFactory.getGCode("M105", -105);
    public static final GCode M20 = GCodeFactory.getGCode("M20", -20);
    public static final GCode M27 = GCodeFactory.getGCode("M27", -20);
    public static final String serial = "SERIAL";
    public static final String io = "IO";
    private ConsoleIf cons = null;
    private PrinterConnection mConn = null;
    private final PrintQueue printQueue = new PrintQueue();
    private final ReceiveBuffer ioBuffer = new ReceiveBuffer(4096);
    private StringBuffer sdfiles = new StringBuffer();
    private Thread runner = null;
    private long printstart;
    private long sendtime = 0L;
    private long starttime = 0L;
    private long garbagetime = 0L;
    private long lastTempWatch = 0L;
    private float testrunavg = 0.0f;
    private int tempwatchintervall = 10000;
    private boolean resetoninit = true;
    private boolean logerrors = true;
    private boolean recover = false;
    private boolean homexyfinish = false;
    private int movespeed = 3000;
    int timeout = 10000;
    public States state = new States();

    protected boolean isHomeXYfinish() {
        return this.homexyfinish;
    }

    public void setHomeXYfinish(boolean homexyfinish) {
        this.homexyfinish = homexyfinish;
    }

    public boolean isResetoninit() {
        return this.resetoninit;
    }

    public void setResetoninit(boolean resetoninit) {
        this.resetoninit = resetoninit;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMovespeed(int movespeed) {
        this.movespeed = movespeed;
    }

    public SerialPrinter(ConsoleIf console) {
        this.cons = console;
        this.cons.appendText("Not connected. Press connect button to establish printer connection.");
    }

    public void setConsole(ConsoleIf conso) {
        this.cons = conso;
    }

    @Override
    public boolean addToPrintQueue(GCode code, boolean manualOnly) {
        if (!code.isPrintable()) {
            return true;
        }
        if (this.state.connecting) {
            this.cons.appendText("Still connecting. Please wait until connecting is established.");
            return false;
        }
        if (!this.state.connected) {
            this.cons.appendText("Not connected");
            return false;
        }
        if (this.state.reset) {
            this.cons.appendText("Still resetting....");
            return false;
        }
        if (manualOnly && this.state.printing && !this.state.pause) {
            this.cons.appendText("Stop or Pause printing first");
            return false;
        }
        try {
            this.printQueue.put(code);
            if (this.state.debug) {
                this.cons.appendTextNoCR("Queued -> " + code.getCodeline());
            }
        }
        catch (InterruptedException e) {
            if (this.state.debug) {
                this.cons.appendText("printQueue.put has been interruped");
            }
            return false;
        }
        return true;
    }

    public boolean connect(PrinterConnection type, int baud) {
        this.state.connecting = true;
        this.cons.updateState("Connecting", "Establishing printer connection", 0);
        this.state.baud = baud;
        this.mConn = type;
        boolean succ = this.mConn.enumerate();
        if (!succ) {
            this.state.connecting = false;
            this.state.connected = false;
            this.cons.updateState("Disconnected", "Please connect", 0);
        }
        return succ;
    }

    public void connectTo(String device) {
        this.mConn.requestDevice(device);
    }

    public void startRunnerThread() {
        if (this.runner == null || !this.runner.isAlive() || this.recover) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            block5: {
                this.cons.appendText("Closing connection !");
                if (this.state.printing) {
                    this.state.printing = false;
                }
                try {
                    this.state.connected = false;
                    this.state.connecting = false;
                    this.state.reset = false;
                    this.mConn.closeDevice();
                    if (this.runner != null && this.runner != Thread.currentThread()) {
                        this.runner.interrupt();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.runner == null || this.runner == Thread.currentThread()) break block5;
                    this.runner.interrupt();
                }
            }
            this.runner = null;
        }
        this.cons.updateState("Disconnected", "Please connect", 0);
    }

    private void doInit() {
        if (this.state.printing) {
            this.setPrintMode(false);
        }
        this.printQueue.clear();
        this.state.lastE = 0.0f;
        this.state.lastpos = new float[3];
        try {
            if (this.mConn.init(this.resetoninit)) {
                this.state.connected = true;
                this.state.connecting = false;
                this.cons.updateState("Connected", "Ready to start printing", 0);
            }
        }
        catch (Exception e) {
            if (this.state.debug) {
                this.cons.appendText("Init failed:" + e.getMessage());
            }
            e.printStackTrace();
            this.disconnect();
        }
    }

    private void doReset() {
        if (this.state.connected) {
            try {
                if (this.state.printing) {
                    this.setPrintMode(false);
                }
                this.printQueue.clear();
                this.mConn.reset();
                ReceiveBuffer recv = this.readResponse(10000);
                if (recv.isEmpty()) {
                    this.cons.appendText("No printer response after reset ! Your hardware might not support reset over serial.");
                } else {
                    this.cons.appendTextNoCR(recv);
                }
                this.state.lastE = 0.0f;
                this.state.lastpos = new float[3];
                this.state.swallows = 0;
                this.state.unexpected = 0;
                this.state.timeouts = 0;
                this.state.printspeed = 100;
                this.state.extrfactor = 100;
            }
            catch (Exception e) {
                if (this.state.debug) {
                    this.cons.appendText("Reset failed or interrupted:" + e);
                }
                e.printStackTrace();
            }
            this.state.reset = false;
        }
    }

    private void doTestRun() throws InterruptedException {
        Model mod = new Model("testrun");
        ArrayList<GCode> arr = mod.getGcodes();
        arr.add(GCodeFactory.getGCode("G90", 0));
        int i = 0;
        while (i < 5000) {
            GCode gco = GCodeFactory.getGCode("G1 X10 Y10", i);
            arr.add(gco);
            ++i;
        }
        arr.add(GCodeFactory.getGCode("M114", 5002));
        mod.analyze();
        this.printQueue.addModel(mod);
        this.setPrintMode(true);
    }

    @Override
    public GCode getCurrentGCode() {
        return this.state.lastgcode;
    }

    public CharSequence getRemainingtime() {
        int len = Constants.formatTimetoHHMMSS(this.printQueue.getRemainingtime(), this.state.timestring.getBytes());
        this.state.timestring.setlength(len - 3);
        return this.state.timestring;
    }

    public void homeAxis(Axis move) {
        String code;
        if (move == null) {
            this.cons.appendText("Home all axis");
            code = "G28";
        } else {
            this.cons.appendText("Home " + move.toString() + " axis");
            code = "G28 " + move.toString();
        }
        this.addToPrintQueue(GCodeFactory.getGCode(code, 1), true);
    }

    @Override
    public boolean isPause() {
        return this.state.pause;
    }

    public boolean isDebug() {
        return this.state.debug;
    }

    @Override
    public boolean isPrinting() {
        return this.state.printing;
    }

    public boolean isConnected() {
        return this.state.connected || this.state.connecting;
    }

    public void moveStep(Axis move, int sign) {
        this.moveStep(move, sign, this.movespeed);
    }

    public void listSDCard() {
        this.sdfiles.setLength(0);
        this.addToPrintQueue(GCodeFactory.getGCode("M21", -21), true);
        this.addToPrintQueue(M20, true);
    }

    public void moveStep(Axis move, int sign, int speed) {
        this.cons.appendText("Move " + (Object)((Object)move));
        String code = "G1 " + move.toString() + this.state.distance * (float)sign + " F" + speed;
        boolean res = this.addToPrintQueue(GCodeFactory.getGCode("G91", 0), true);
        if (res) {
            res = this.addToPrintQueue(GCodeFactory.getGCode(code, 0), true);
        }
        if (res) {
            res = this.addToPrintQueue(GCodeFactory.getGCode("G90", 0), true);
        }
        if (res) {
            this.addToPrintQueue(GCodeFactory.getGCode("M114", 0), true);
        }
    }

    public void moveToPos(int x, int y, int speed) {
        if (speed == 0) {
            speed = this.movespeed;
        }
        String code = "G1 X" + x + " Y" + y + " F" + speed;
        boolean res = this.addToPrintQueue(GCodeFactory.getGCode("G90", 0), true);
        if (res) {
            this.addToPrintQueue(GCodeFactory.getGCode(code, 1), true);
        }
    }

    public void moveToPos(int x, int y, int speed, float extrude) {
        float ymove;
        float xmove;
        String code = "G1 X" + x + " Y" + y + " F" + speed;
        if (x > 200 || x < 0 || y > 200 || y < 0) {
            this.cons.log("GCODE", "Invalid gcode " + code);
        }
        if ((xmove = Math.abs(this.state.lastpos[0] - (float)x)) + (ymove = Math.abs(this.state.lastpos[1] - (float)y)) == 0.0f) {
            return;
        }
        this.state.lastpos[0] = x;
        this.state.lastpos[1] = y;
        float move = (float)Math.sqrt(xmove * xmove + ymove * ymove);
        if (this.state.lastE == 0.0f) {
            this.addToPrintQueue(GCodeFactory.getGCode("G90", 0), true);
            this.addToPrintQueue(GCodeFactory.getGCode("M82", 0), true);
            this.addToPrintQueue(GCodeFactory.getGCode("G92 E0", 0), true);
        }
        this.state.lastE += extrude * move;
        code = String.valueOf(code) + " E" + this.state.lastE;
        this.addToPrintQueue(GCodeFactory.getGCode(code, 1), true);
    }

    private void printAndWaitQueue() throws InterruptedException {
        GCode code = null;
        if (System.currentTimeMillis() - this.lastTempWatch < (long)this.tempwatchintervall || !this.state.printing && !this.printQueue.isManualEmpty() || this.state.streaming) {
            if (this.state.printing && !this.state.pause && this.printQueue.isManualEmpty()) {
                code = this.printQueue.pollAuto();
                if (code == null) {
                    this.state.lastgcode = G0;
                    if (this.state.percentCompleted >= 100) {
                        this.state.sdprint = false;
                    }
                    if (this.state.sdprint) {
                        code = M27;
                    } else {
                        this.setPrintMode(false);
                    }
                } else {
                    this.state.lastgcode = code;
                }
                if (this.logerrors && Constants.lastGarbage - this.garbagetime > 0L) {
                    this.garbagetime = Constants.lastGarbage;
                    this.cons.appendText("Garbage collector run during print !");
                    this.cons.log("GC", String.valueOf(this.garbagetime));
                }
            } else {
                code = this.printQueue.pollManual(1);
            }
        } else {
            code = M105;
            this.lastTempWatch = System.currentTimeMillis();
        }
        if (this.state.reset || code == null) {
            return;
        }
        this.starttime = System.currentTimeMillis();
        if (this.state.debug) {
            this.cons.appendTextNoCR(String.valueOf(code.getLineindex()), ": ", code.getCodeline());
            if (code.isBuffered() && (double)code.getTimeAccel() > 0.2) {
                this.cons.appendText("(Est.Time:", String.valueOf(Constants.round3digits(code.getTimeAccel())), "s)");
            }
        }
        if (this.state.debug) {
            this.cons.log(serial, "write gcode line:" + code.getLineindex());
            this.cons.log(serial, code.getGcode().toString());
        }
        int len = code.getCodeline(this.ioBuffer.array);
        this.ioBuffer.setlength(len);
        this.mConn.writeBuffer(this.ioBuffer);
        this.cons.log(io, null, this.ioBuffer);
        this.sendtime = System.currentTimeMillis();
        this.state.readcalls = 0;
        while (this.state.connected && !this.state.reset) {
            if (this.mConn.getType() == 1) {
                Thread.sleep(5L);
            }
            ReceiveBuffer recv = this.readResponse(code.isLongRunning() ? 60000 : this.timeout);
            this.cons.log(io, null, recv);
            if (this.state.reset) break;
            if (this.state.debug && code.isBuffered() && System.currentTimeMillis() - this.sendtime > 400L) {
                float resptime = Constants.round3digits((float)(System.currentTimeMillis() - this.sendtime) / 1000.0f);
                this.cons.appendText("Wait for printer response: ", String.valueOf(resptime), "s");
            }
            if (recv.isEmpty() || recv.isTimedout()) {
                ++this.state.timeouts;
                this.state.timeoutline = code.getLineindex();
                if (!this.state.debug && !this.logerrors) break;
                String logm = "Timeout waiting for printer response at line #" + this.state.timeoutline + "(" + String.valueOf(System.currentTimeMillis() - this.starttime) + "ms)";
                this.cons.appendText(logm);
                this.cons.log("ERROR", logm);
                break;
            }
            if (this.state.debug || !recv.isPlainOK() && code != M105) {
                this.cons.appendTextNoCR(recv);
            }
            if (this.state.streaming && recv.containsFail()) {
                this.cons.appendText("Error during streaming, abort");
                this.setPrintMode(false);
            }
            if (recv.containsOK() || recv.containsWait()) {
                if (code == M105 && recv.containsTx()) {
                    try {
                        int idx1 = recv.indexOf('T');
                        int idx = recv.indexOf('@');
                        this.state.tempstring = idx == -1 || idx1 == -1 ? recv.subSequence(3, recv.length(), this.state.tempstring) : recv.subSequence(idx1, idx, this.state.tempstring);
                        this.cons.setTemp(this.state.tempstring);
                    }
                    catch (Exception e) {
                        this.cons.appendText("Error parsing temperature: " + recv.toString());
                        e.printStackTrace();
                    }
                } else {
                    if (code == M105 && recv.isPlainOK()) {
                        ++this.state.swallows;
                        if (!this.state.debug && !this.logerrors) continue;
                        this.cons.appendText("Swallow OK");
                        this.cons.log("ERROR", "Swallow OK");
                        continue;
                    }
                    if (code == M20) {
                        this.sdfiles.append(recv.toString());
                        String[] fout = this.sdfiles.toString().toLowerCase().split("\n");
                        if (fout.length > 3) {
                            String[] fnew = new String[fout.length - 3];
                            System.arraycopy(fout, 1, fnew, 0, fout.length - 3);
                            this.cons.chooseDialog(fnew, fnew, 2);
                        } else {
                            this.cons.chooseDialog(null, null, 2);
                        }
                    } else if (code == M27) {
                        this.state.percentCompleted = recv.parseSDStatus();
                    }
                }
                float diff = System.currentTimeMillis() - this.starttime;
                if (!this.state.testrun) break;
                this.testrunavg += diff;
                if (!(diff > 50.0f)) break;
                this.cons.log("GCodeLongTime", String.valueOf(code.getLineindex()));
                this.cons.log("GCodeLongTime", String.valueOf(diff));
                this.cons.appendText("Took (overall ms): ", String.valueOf(diff));
                break;
            }
            if (recv.containsTx()) {
                this.state.tempstring = recv.subSequence(0, recv.length(), this.state.tempstring);
                this.cons.setTemp(this.state.tempstring);
            }
            if (code.isBuffered() && !recv.startsWithEcho() && !recv.startsWithGO()) {
                ++this.state.unexpected;
                this.cons.appendText("Unexpected response from printer: " + recv.toString());
                this.cons.log("ERROR", "Unexpected response from printer");
            }
            if (code != M20) continue;
            this.cons.log("serial", "Add file output:" + recv.toString());
            this.sdfiles.append(recv.toString());
        }
        if (this.isPrinting()) {
            if (this.state.sdprint) {
                this.cons.updateState("Streaming to SD", "unknown", this.state.percentCompleted);
            } else if (this.state.percentCompleted != this.printQueue.getPercentCompleted()) {
                this.state.percentCompleted = this.printQueue.getPercentCompleted();
                if (this.state.streaming) {
                    this.cons.updateState("Streaming to SD", "unknown", this.state.percentCompleted);
                } else {
                    this.cons.updateState("Printing", this.getRemainingtime(), this.state.percentCompleted);
                }
            }
        }
    }

    public void printModel(Model pm, String sdfilename, boolean autostart) throws InterruptedException {
        if (this.state.connecting) {
            this.cons.appendText("Still connecting. Please wait until connecting is established.");
            return;
        }
        if (!this.state.connected) {
            this.cons.appendText("Not connected");
            return;
        }
        if (sdfilename == null) {
            this.cons.appendText("Add model to print queue");
            this.printQueue.addModel(pm);
            if (this.state.debug) {
                this.cons.appendText("Filling print queue, Printing:" + this.state.printing);
            }
        } else if (pm != null) {
            this.printQueue.putAuto(GCodeFactory.getGCode("M21", -21));
            this.printQueue.putAuto(GCodeFactory.getGCode("M28 " + sdfilename, -28));
            this.state.streaming = true;
            GCode finishstream = GCodeFactory.getGCode("M29 " + sdfilename, -29);
            if (autostart) {
                GCode selectfile = GCodeFactory.getGCode("M23 " + sdfilename, -23);
                GCode printfile = GCodeFactory.getGCode("M24", -24);
                this.printQueue.addModel(pm, finishstream, selectfile, printfile);
                this.state.sdprint = true;
            } else {
                this.printQueue.addModel(pm, finishstream);
            }
            if (this.state.debug) {
                this.cons.appendText("Filling queue to stream, streaming:" + this.state.printing);
            }
        } else {
            this.printQueue.putAuto(GCodeFactory.getGCode("M23 " + sdfilename, -23));
            this.printQueue.putAuto(GCodeFactory.getGCode("M24", -24));
            this.state.sdprint = true;
            if (this.state.debug) {
                this.cons.appendText("SD print, Printing:" + this.state.printing);
            }
        }
        this.setPrintMode(true);
    }

    public Model getModel() {
        return this.printQueue.getPrintModel();
    }

    public ReceiveBuffer readResponse(int timeout) {
        this.ioBuffer.clear();
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time < (long)timeout && this.isConnected()) {
            this.mConn.read(this.ioBuffer);
            if (this.state.debug) {
                this.cons.log(serial, "Data Received:" + this.ioBuffer.toString().trim());
            }
            if (this.ioBuffer.endsWithNewLine()) {
                return this.ioBuffer;
            }
            if (!this.state.debug) continue;
            this.cons.log(serial, "Incomplete response, wait for more inBuffer=" + this.ioBuffer.length());
        }
        if (this.isConnected()) {
            this.ioBuffer.setTimedout(true);
        }
        return this.ioBuffer;
    }

    public void reset() {
        if (this.state.reset) {
            return;
        }
        if (this.state.connected) {
            this.cons.appendText("Reset connection");
            this.state.reset = true;
        } else {
            this.cons.appendText("Not connected");
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(10);
        Thread.currentThread().setName("SerialRunner");
        if (!this.recover) {
            this.doInit();
        }
        while (this.state.connected) {
            if (this.state.reset) {
                this.doReset();
                continue;
            }
            try {
                this.printAndWaitQueue();
                if (!this.state.testrun || this.state.printing) continue;
                this.doTestRun();
            }
            catch (InterruptedException e) {
                this.cons.log(serial, "PrintThread Interrupted" + e);
            }
        }
        this.cons.log(serial, "Runner Thread interrupted");
    }

    public void onRunError(Exception arg0, String arg1) {
        if (this.state.debug) {
            this.cons.appendText(String.valueOf(arg1) + " Error:" + arg0.getMessage());
        }
        this.cons.log("ERROR", String.valueOf(arg1) + " Error:" + arg0);
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setBedTemp(float tmp) {
        this.cons.appendText("Set Bed Temperature to " + tmp + "\u00b0C");
        return this.addToPrintQueue(GCodeFactory.getGCode("M140 S" + tmp, 0), true);
    }

    public boolean setExtruderTemp(float tmp) {
        this.cons.appendText("Set Extruder Temperature to " + tmp + "\u00b0C");
        return this.addToPrintQueue(GCodeFactory.getGCode("M104 S" + tmp, 0), true);
    }

    public boolean setPrintSpeed(int percentage) {
        if (percentage <= 0) {
            this.cons.appendText("Speed to low, please increase speed");
            return false;
        }
        if (percentage > this.state.printspeed) {
            this.cons.appendText("Speed-up print to " + percentage + "%");
        } else {
            this.cons.appendText("Slow down print to " + percentage + "%");
        }
        this.state.printspeed = percentage;
        return this.addToPrintQueue(GCodeFactory.getGCode("M220 S" + percentage, -220), false);
    }

    public boolean setExtrusionFactor(int percentage) {
        if (percentage <= 0) {
            this.cons.appendText("Factor to low, please increase extrusion");
            return false;
        }
        if (percentage > this.state.printspeed) {
            this.cons.appendText("Increase extrusion to " + percentage + "%");
        } else {
            this.cons.appendText("Reduce extrusion to " + percentage + "%");
        }
        this.state.extrfactor = percentage;
        return this.addToPrintQueue(GCodeFactory.getGCode("M221 S" + percentage, -221), false);
    }

    public int getPrintSpeed() {
        return this.state.printspeed;
    }

    public int getExtrusionFactor() {
        return this.state.extrfactor;
    }

    @Override
    public void setPrintMode(boolean isprinting) {
        this.state.printing = isprinting;
        this.cons.appendText("Set printing " + this.state.printing);
        this.cons.setPrinting(isprinting);
        if (!isprinting) {
            String fin = "Print finished in " + (System.currentTimeMillis() - this.printstart) / 1000L + "s";
            this.cons.log(serial, fin);
            this.cons.appendText(fin);
            this.printQueue.clear();
            if (this.state.testrun) {
                this.cons.appendText("Testrun completed, average response time (ms):" + this.testrunavg / 5002.0f);
                this.testrunavg = 0.0f;
                this.state.testrun = false;
            }
            this.state.lastgcode = GCodeFactory.getGCode("G0", 0);
            if (this.state.streaming) {
                this.addToPrintQueue(GCodeFactory.getGCode("M29", -29), true);
            }
            this.addToPrintQueue(GCodeFactory.getGCode("M104 S0", -104), true);
            this.addToPrintQueue(GCodeFactory.getGCode("M140 S0", -140), true);
            if (this.homexyfinish) {
                this.addToPrintQueue(GCodeFactory.getGCode("G28 X0 Y0", -128), true);
            }
            if (this.state.printspeed != 100) {
                this.addToPrintQueue(GCodeFactory.getGCode("M220 100", -220), true);
            }
            if (this.state.extrfactor != 100) {
                this.addToPrintQueue(GCodeFactory.getGCode("M221 100", -221), true);
            }
            this.state.printspeed = 100;
            this.state.extrfactor = 100;
            this.cons.updateState("Print Finshed", fin, -1);
            this.state.sdprint = false;
            this.state.streaming = false;
            if (this.state.debug) {
                this.cons.appendText(this.showDebugData());
            }
            this.cons.log("DEBUG", this.showDebugData());
        } else {
            System.gc();
            this.printstart = System.currentTimeMillis();
            this.garbagetime = this.printstart + 12000L;
            this.state.percentCompleted = 0;
            if (this.state.streaming || this.state.sdprint) {
                this.cons.updateState("Streaming to SD", "unknown", 0);
            } else {
                this.cons.updateState("Printing", this.getRemainingtime(), 0);
            }
        }
    }

    public void setStepSize(float steps) {
        this.cons.appendText("Set move distance to " + steps + "mm");
        this.state.distance = steps;
    }

    public void setTempWatchIntervall(int ms) {
        this.tempwatchintervall = ms;
    }

    public void stopMotor() {
        this.cons.appendText("Stop all motors");
        this.addToPrintQueue(GCodeFactory.getGCode("M84", 0), true);
    }

    public void testrun() {
        if (this.state.connecting) {
            this.cons.appendText("Still connecting. Please wait until connecting is established.");
            return;
        }
        if (!this.state.connected) {
            this.cons.appendText("Not connected");
            return;
        }
        this.cons.appendText("Start communication test");
        this.state.testrun = true;
    }

    public void tryRecovery() {
        if (this.mConn == null || !this.isPrinting() || System.currentTimeMillis() - this.starttime < 15000L) {
            return;
        }
        this.recover = true;
        this.startRunnerThread();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.mConn.tryrecover();
    }

    public void toggleBaud() {
        if (this.state.connected || this.state.connecting) {
            this.cons.appendText("Please disconnect before changing the baud rate.");
            return;
        }
        this.state.baud = this.state.baud == 115200 ? 250000 : 115200;
        this.cons.appendText("Set Baud " + this.state.baud);
    }

    public void setDebug(boolean db) {
        this.state.debug = db;
        this.cons.appendText(this.showDebugData());
        this.cons.appendText("Set debug " + this.state.debug);
    }

    public void toggleFan() {
        if (this.state.fan) {
            this.cons.appendText("Disable Fan");
            this.addToPrintQueue(GCodeFactory.getGCode("M107", 0), false);
        } else {
            this.cons.appendText("Enable Fan");
            this.addToPrintQueue(GCodeFactory.getGCode("M106", 0), false);
        }
        this.state.fan = !this.state.fan;
    }

    public void togglePause() {
        if (this.state.sdprint) {
            if (this.state.pause) {
                this.state.pause = false;
                this.addToPrintQueue(GCodeFactory.getGCode("M24", -24), false);
            } else {
                this.addToPrintQueue(GCodeFactory.getGCode("M25", -25), false);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.state.pause = true;
            }
        } else {
            boolean bl = this.state.pause = !this.state.pause;
        }
        if (this.state.pause) {
            this.cons.appendText("Pause");
            if (this.state.debug) {
                this.cons.appendText("Pause at GCode line number:" + this.state.lastgcode.getLineindex());
                this.cons.appendText(this.showDebugData());
            }
        } else {
            this.cons.appendText("Continue");
        }
        if (this.state.printing) {
            if (this.state.pause) {
                this.cons.updateState("Printing Paused", null, -1);
            } else {
                this.cons.updateState("Printing", null, -1);
            }
        }
    }

    public String showDebugData() {
        StringBuilder str = new StringBuilder();
        str.append("-----------------Debug Data---------------------------");
        str.append('\n');
        str.append("Connected/Connecting/reset:");
        str.append(this.state.connected);
        str.append("/");
        str.append(this.state.connecting);
        str.append("/");
        str.append(this.state.reset);
        str.append('\n');
        str.append("Baud:");
        str.append(this.state.baud);
        str.append('\n');
        str.append("Last GCode:");
        str.append(this.state.lastgcode.getCodeline().toString().trim());
        str.append('\n');
        str.append("Printing:");
        str.append(this.state.printing);
        str.append('\n');
        str.append("Streaming:");
        str.append(this.state.streaming);
        str.append('\n');
        str.append("Serial Port:");
        str.append(this.state.serialtype);
        str.append('\n');
        if (this.state.printing) {
            str.append("Print Start:");
            str.append(new Date(this.printstart));
            str.append('\n');
            str.append("SD Card streaming/print:");
            str.append(this.state.streaming);
            str.append('/');
            str.append(this.state.sdprint);
            str.append('\n');
            if (this.getModel() != null) {
                str.append("Filename:");
                str.append(this.getModel().getFilename());
                str.append('\n');
            }
        }
        str.append("Temperature:");
        str.append(this.state.tempstring.toString().trim());
        str.append('\n');
        str.append("TempWatch Intervall:");
        str.append(this.tempwatchintervall);
        str.append('\n');
        str.append("Communication Timeout (occurrences):");
        str.append(this.timeout);
        str.append("(");
        str.append(this.state.timeouts);
        str.append(")");
        str.append('\n');
        str.append("Last com. timeout linenr:");
        str.append(this.state.timeoutline);
        str.append('\n');
        str.append("Unexpected response:");
        str.append(this.state.unexpected);
        str.append('\n');
        str.append("Swallow OK:");
        str.append(this.state.swallows);
        str.append('\n');
        str.append("Read calls:");
        str.append(this.state.readcalls);
        str.append('\n');
        str.append("Wakelock:");
        str.append(this.cons.hasWakeLock());
        str.append('\n');
        str.append("Time since last send:");
        str.append(System.currentTimeMillis() - this.starttime);
        str.append('\n');
        str.append("Manual Print Queue:");
        str.append(this.printQueue.getSizeManual());
        str.append('\n');
        str.append("Auto Print Queue:");
        str.append(this.printQueue.getSizeAuto());
        str.append('\n');
        if (Constants.lastGarbage != 0L) {
            str.append("Last Garbage Collection:");
            str.append(new Date(Constants.lastGarbage));
            str.append('\n');
        }
        if (this.runner != null) {
            str.append("RunnerThread Alive:");
            str.append(this.runner.isAlive());
            str.append('\n');
            StackTraceElement[] stack = this.runner.getStackTrace();
            str.append("RunnerThread Stack:");
            int i = 0;
            while (i < stack.length) {
                str.append(stack[i].toString());
                str.append('\n');
                ++i;
            }
        }
        str.append("--------------------------------------------");
        str.append('\n');
        return str.toString();
    }

    public static enum Axis {
        E,
        X,
        Y,
        Z;

    }

    public class States {
        public static final String CONNECTED = "Connected";
        public static final String FINISHED = "Print Finshed";
        public static final String DISCONNECTED = "Disconnected";
        public static final String CONNECTING = "Connecting";
        public static final String PRINTING = "Printing";
        public static final String STREAMING = "Streaming to SD";
        public static final String PAUSED = "Printing Paused";
        public static final String CONNECTMSG = "Please connect";
        public static final String CONNECTINGMSG = "Establishing printer connection";
        public static final String CONNECTEDMSG = "Ready to start printing";
        public int baud = 115200;
        public float bedtemp = 0.0f;
        public boolean connected = false;
        public boolean connecting = false;
        public boolean debug = false;
        public float distance = 1.0f;
        public float extemp = 0.0f;
        public boolean fan = false;
        public float lastE = 0.0f;
        public GCode lastgcode = G0;
        public float[] lastpos = new float[]{0.0f, 0.0f, 0.0f};
        public boolean pause = false;
        public boolean printing = false;
        public boolean streaming = false;
        public boolean sdprint = false;
        public boolean reset = false;
        public int printspeed = 100;
        public int extrfactor = 100;
        public int timeouts = 0;
        public int timeoutline = 0;
        public int unexpected = 0;
        public int swallows = 0;
        public int readcalls = 0;
        public String serialtype = "";
        public int percentCompleted = 0;
        public MemoryEfficientString tempstring = new MemoryEfficientString(new byte[64]);
        public MemoryEfficientLenString timestring = new MemoryEfficientLenString(new byte[32]);
        boolean testrun = false;

        public float getX() {
            return this.lastpos[0];
        }

        public float getY() {
            return this.lastpos[1];
        }

        public float getZ() {
            return this.lastpos[2];
        }
    }
}

