/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm;

import de.dietzm.gcodes.MemoryEfficientLenString;
import de.dietzm.gcodes.MemoryEfficientString;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Constants {
    static char[] buffer = new char[1024];
    static List<String> list = new ArrayList<String>();
    public static long lastGarbage = 0L;
    public static final short E_MASK = 1;
    public static final short F_MASK = 2;
    public static final short X_MASK = 4;
    public static final short Y_MASK = 8;
    public static final short Z_MASK = 16;
    public static final short SF_MASK = 32;
    public static final short SE_MASK = 64;
    public static final short SB_MASK = 128;
    public static final short R_MASK = 256;
    public static final short IX_MASK = 512;
    public static final short JY_MASK = 1024;
    public static final short KZ_MASK = 2048;
    public static final String ENCODING = "ISO-8859-1";
    public static final byte newlineb = 10;
    public static final byte spaceb = 32;
    public static final byte[] newline = new byte[]{10};
    public static final char newlinec = '\n';
    public static final String RETRACT_LABEL = "R";
    public static final String XYSPEED_LABEL = "XY Speed";
    public static final String ESPEED_LABEL = "E Speed";
    public static final String ZPOS_LABEL = "Z Position";
    public static final String FAN_LABEL = "Fan";
    public static final String PRINT_LABEL = "Print";
    public static final String PRINTSTART_LABEL = "#";
    public static final String SPEEDUP_LABEL = "Speedup";
    public static final String REMTIME_LABEL = "Remaining Time";
    public static final String LAYER_LABEL = "Layer #";
    public static final String ZERO_LABEL = "0";
    public static final String FANS0_LABEL = "";
    public static final String FANS1_LABEL = "I";
    public static final String FANS2_LABEL = "II";
    public static final String FANS3_LABEL = "III";

    public static String formatTimetoHHMMSS(float secs, StringBuilder buf) {
        int secsIn = Math.round(secs);
        int hours = secsIn / 3600;
        int remainder = secsIn % 3600;
        int minutes = remainder / 60;
        int seconds = remainder % 60;
        if (buf == null) {
            buf = new StringBuilder();
        }
        buf.append(hours);
        buf.append(":");
        buf.append(minutes < 10 ? ZERO_LABEL : FANS0_LABEL);
        buf.append(minutes);
        buf.append(":");
        buf.append(seconds < 10 ? ZERO_LABEL : FANS0_LABEL);
        buf.append(seconds);
        return buf.toString();
    }

    public static int formatTimetoHHMMSS(float secs, byte[] buf) {
        int secsIn = Math.round(secs);
        int hours = secsIn / 3600;
        int remainder = secsIn % 3600;
        int minutes = remainder / 60;
        int seconds = remainder % 60;
        if (buf == null) {
            buf = new byte[10];
        }
        int cnt = 0;
        if (hours > 999) {
            buf[cnt++] = (byte)Character.forDigit(hours / 1000 % 10, 10);
        }
        if (hours > 99) {
            buf[cnt++] = (byte)Character.forDigit(hours / 100 % 10, 10);
        }
        if (hours > 9) {
            buf[cnt++] = (byte)Character.forDigit(hours / 10 % 10, 10);
        }
        buf[cnt++] = (byte)Character.forDigit(hours % 10, 10);
        buf[cnt++] = 58;
        buf[cnt++] = (byte)Character.forDigit(minutes / 10, 10);
        buf[cnt++] = (byte)Character.forDigit(minutes % 10, 10);
        buf[cnt++] = 58;
        buf[cnt++] = (byte)Character.forDigit(seconds / 10, 10);
        buf[cnt++] = (byte)Character.forDigit(seconds % 10, 10);
        int cntnew = cnt;
        while (cntnew < buf.length) {
            buf[cntnew++] = 0;
        }
        return cnt;
    }

    public static MemoryEfficientString inttoChar(int value, MemoryEfficientLenString result) {
        int nr = Constants.inttoChar(value, result.getBytes());
        result.setlength(nr);
        return result;
    }

    public static MemoryEfficientString floattoChar(float value, MemoryEfficientLenString result, int digits) {
        int nr = Constants.floattoChar(value, result.getBytes(), digits);
        result.setlength(nr);
        return result;
    }

    public static int inttoChar(int value, byte[] result) {
        int cnt = 0;
        if (value == 0) {
            result[cnt++] = 48;
        } else {
            if (value < 0) {
                result[cnt++] = 45;
                value = -value;
            }
            if (value == Integer.MIN_VALUE) {
                result[cnt++] = 50;
                value = 147483648;
            }
            int t = 1000000000;
            while (value < t) {
                t /= 10;
            }
            while (t > 0) {
                int d = value / t;
                result[cnt++] = (byte)(48 + d);
                value -= d * t;
                t /= 10;
            }
        }
        int cntnew = cnt;
        while (cntnew < result.length) {
            result[cntnew++] = 0;
        }
        return cnt;
    }

    public static int floattoChar(float val, byte[] result, int digits) {
        int cnt = 0;
        int multip = (int)Math.pow(10.0, digits);
        int value = (int)(val * (float)multip);
        if (value == 0) {
            result[cnt++] = 48;
        } else {
            if (value < 0) {
                result[cnt++] = 45;
                value = -value;
            }
            if (value == Integer.MIN_VALUE) {
                result[cnt++] = 50;
                value = 147483648;
            }
            int t = 1000000000;
            while (value < t) {
                t /= 10;
            }
            if (Math.abs(val) < 1.0f) {
                result[cnt++] = 48;
                result[cnt++] = 46;
            }
            while (t > 0) {
                int d = value / t;
                result[cnt++] = (byte)(48 + d);
                if (t == multip) {
                    result[cnt++] = 46;
                }
                value -= d * t;
                t /= 10;
            }
        }
        int cntnew = cnt;
        while (cntnew < result.length) {
            result[cntnew++] = 0;
        }
        return cnt;
    }

    public static void main(String[] args) {
        MemoryEfficientString me = new MemoryEfficientString(new byte[12]);
        Constants.formatTimetoHHMMSS(393699.0f, me.getBytes());
        System.out.println(me.toString());
        Constants.floattoChar(1.1f, me.getBytes(), 2);
        System.out.println(me.toString());
        Constants.floattoChar(-0.1f, me.getBytes(), 2);
        System.out.println(me.toString());
        Constants.floattoChar(0.99f, me.getBytes(), 2);
        System.out.println(me.toString());
        Constants.inttoChar(Integer.MIN_VALUE, me.getBytes());
        float f = 0.0054454f;
        System.out.println(Constants.parseFloat("0.0054454545", 0));
    }

    public static float round2digits(float num) {
        return (float)Math.round(num * 100.0f) / 100.0f;
    }

    public static boolean isValidGCode(String codeline) {
        if (codeline == null || codeline.isEmpty()) {
            return false;
        }
        if (codeline.charAt(0) == 'G' || codeline.charAt(0) == 'g') {
            return true;
        }
        if (codeline.charAt(0) == 'M' || codeline.charAt(0) == 'm') {
            return true;
        }
        return codeline.charAt(0) == 'T' || codeline.charAt(0) == 't';
    }

    public static float round3digits(float num) {
        return (float)Math.round(num * 1000.0f) / 1000.0f;
    }

    public static String removeTrailingZeros(String var) {
        return var.replaceAll("[0]*$", FANS0_LABEL).replaceAll("\\.$", FANS0_LABEL);
    }

    public static float parseFloat(String f, int startpos) {
        int len = f.length();
        float ret = 0.0f;
        int pos = startpos;
        int part = 0;
        boolean neg = false;
        while (pos < len && (f.charAt(pos) < '0' || f.charAt(pos) > '9') && f.charAt(pos) != '-' && f.charAt(pos) != '.') {
            ++pos;
        }
        if (f.charAt(pos) == '-') {
            neg = true;
            ++pos;
        }
        while (pos < len && f.charAt(pos) <= '9' && f.charAt(pos) >= '0') {
            part = part * 10 + (f.charAt(pos++) - 48);
        }
        float f2 = ret = neg ? (float)(part * -1) : (float)part;
        if (pos < len && f.charAt(pos) == '.') {
            ++pos;
            int mul = 1;
            part = 0;
            while (pos < len && f.charAt(pos) <= '9' && f.charAt(pos) >= '0') {
                part = part * 10 + (f.charAt(pos) - 48);
                mul *= 10;
                ++pos;
            }
            float f3 = ret = neg ? ret - (float)part / (float)mul : ret + (float)part / (float)mul;
        }
        if (pos < len && (f.charAt(pos) == 'e' || f.charAt(pos) == 'E')) {
            neg = f.charAt(++pos) == '-';
            ++pos;
            part = 0;
            while (pos < len && f.charAt(pos) <= '9' && f.charAt(pos) >= '0') {
                part = part * 10 + (f.charAt(pos++) - 48);
            }
            ret = neg ? (ret /= (float)Math.pow(10.0, part)) : (ret *= (float)Math.pow(10.0, part));
        }
        return ret;
    }

    public static String[] splitbyLetter(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        int trailws = 0;
        int len = text.length();
        boolean first = true;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c > ':') {
                if (first) {
                    first = false;
                } else {
                    list.add(text.substring(pos, i - trailws));
                    pos = i;
                }
            } else if (i == pos && c == ' ') {
                ++pos;
            } else {
                trailws = c == ' ' ? ++trailws : 0;
            }
            ++i;
        }
        list.add(text.substring(pos, len - trailws));
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitbyLetter2(String text) {
        list.clear();
        int pos = 0;
        int len = text.length();
        boolean first = true;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c > ':') {
                if (first) {
                    first = false;
                    Constants.buffer[pos++] = c;
                } else {
                    list.add(new String(buffer, 0, pos));
                    pos = 0;
                    Constants.buffer[pos++] = c;
                }
            } else if (c != ' ' && c != '\n') {
                Constants.buffer[pos++] = c;
            }
            ++i;
        }
        list.add(new String(buffer, 0, pos));
        return list.toArray(new String[list.size()]);
    }

    public static enum GCDEF {
        G0(0),
        G1(1),
        G2(2),
        G3(3),
        G4(4),
        G20(20),
        G21(21),
        G28(28),
        G29(29),
        G30(30),
        G31(31),
        G32(32),
        G90(90),
        G91(91),
        G92(92),
        G130(130),
        G161(161),
        G162(162),
        M0(1000),
        M1(1001),
        M6(1006),
        M18(1018),
        M20(1020),
        M21(1021),
        M22(1022),
        M23(1023),
        M24(1024),
        M25(1025),
        M26(1026),
        M27(1027),
        M28(1028),
        M29(1029),
        M70(1070),
        M72(1072),
        M73(1073),
        M92(1092),
        M80(1080),
        M81(1081),
        M101(1101),
        M103(1103),
        M104(1104),
        M105(1105),
        M106(1106),
        M107(1107),
        M108(1108),
        M109(1109),
        M112(1112),
        M113(1113),
        M114(1114),
        M116(1116),
        M117(1117),
        M126(1126),
        M127(1127),
        M130(1130),
        M132(1132),
        M133(1133),
        M134(1134),
        M135(1135),
        M136(1136),
        M137(1137),
        M140(1140),
        M190(1190),
        M204(1204),
        M220(1220),
        M221(1221),
        M226(1226),
        M82(1082),
        M83(1083),
        M84(1084),
        T0(5000),
        UNKNOWN(Short.MAX_VALUE),
        COMMENT(Short.MIN_VALUE);

        private short idx;
        private byte[] bytes;
        private static GCDEF[] myvals;

        static {
            myvals = GCDEF.values();
        }

        private GCDEF(int lidx) {
            this.idx = (short)lidx;
            try {
                this.bytes = this.toString().getBytes(Constants.ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("GCDEF Unexpected: ISO-8859-1 not supported!");
            }
        }

        public short getId() {
            return this.idx;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public static GCDEF getGCDEF(String val) {
            if (val.equalsIgnoreCase("G1")) {
                return G1;
            }
            if (val.equalsIgnoreCase("G2")) {
                return G2;
            }
            if (val.equalsIgnoreCase("G3")) {
                return G3;
            }
            if (val.equalsIgnoreCase("G92")) {
                return G92;
            }
            if (val.charAt(0) > 'a') {
                return GCDEF.valueOf(val.toUpperCase());
            }
            return GCDEF.valueOf(val);
        }

        public static GCDEF getGCDEF(short index) {
            if (index == 0) {
                return G0;
            }
            if (index == 1) {
                return G1;
            }
            if (index == 2) {
                return G2;
            }
            if (index == 3) {
                return G3;
            }
            if (index == 92) {
                return G92;
            }
            if (index == Short.MAX_VALUE) {
                return UNKNOWN;
            }
            if (index == Short.MIN_VALUE) {
                return COMMENT;
            }
            GCDEF[] gCDEFArray = myvals;
            int n = myvals.length;
            int n2 = 0;
            while (n2 < n) {
                GCDEF l = gCDEFArray[n2];
                if (l.idx == index) {
                    return l;
                }
                ++n2;
            }
            throw new IllegalArgumentException("GCDEF not found. ");
        }

        public boolean equals(short id) {
            return this.idx == id;
        }
    }
}

