/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm;

import de.dietzm.gcodes.GCode;
import de.dietzm.gcodes.GCodeMemSave;
import de.dietzm.print.Printer;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;

public class SerialIO
implements SerialPortEventListener,
Printer {
    States state = new States();
    InputStream inputStream = null;
    OutputStream outputStream = null;
    StringBuffer result = new StringBuffer();
    LinkedBlockingQueue<GCode> printQueue = new LinkedBlockingQueue(1);

    @Override
    public void setPrintMode(boolean isprinting) {
    }

    @Override
    public boolean isPrinting() {
        return this.state.printing;
    }

    @Override
    public boolean isPause() {
        return this.state.pause;
    }

    public int getLastPrintedLine() {
        return 0;
    }

    @Override
    public GCode getCurrentGCode() {
        return null;
    }

    @Override
    public boolean addToPrintQueue(GCode code, boolean manual) {
        if (!this.state.connected) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        if (manual && this.state.printing) {
            return false;
        }
        if (!manual && !this.state.printing) {
            return false;
        }
        System.out.println("About to add code " + code.hashCode() + " to print queue:" + this.printQueue.size());
        try {
            this.printQueue.put(code);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private synchronized String printAndWaitQueue() throws Exception {
        GCode code = this.printQueue.take();
        if (code == null) {
            return null;
        }
        long starttime = System.currentTimeMillis();
        System.out.println("Print gcode " + code.getCodeline() + " Hash:" + code.hashCode());
        this.outputStream.write(code.getCodeline().getBytes());
        while (true) {
            this.result.setLength(0);
            this.wait(10000L);
            String tempresult = this.result.toString().trim();
            if (tempresult.length() == 0) {
                return null;
            }
            if (tempresult.trim().endsWith("ok")) {
                long endtime = System.currentTimeMillis();
                System.out.println("GCode " + code.hashCode() + " Measured Time: " + (endtime - starttime) + "ms");
                System.out.println("GCode " + code.hashCode() + " CTime: " + code.getTimeAccel() + "s");
                System.out.println("-----------------------------------------------------");
                return tempresult.trim();
            }
            System.out.println("Result " + code.hashCode() + " :" + tempresult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent arg0) {
        if (arg0.getEventType() == 1) {
            SerialIO serialIO = this;
            synchronized (serialIO) {
                byte[] a = new byte[1024];
                int len = 0;
                try {
                    len = this.inputStream.read(a);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.result.append(new String(a, 0, len));
                System.out.println("Data Received:" + this.result.toString().trim());
                if (this.result.toString().endsWith("\n")) {
                    this.notify();
                } else {
                    System.out.println("Incomplete response, wait for more");
                }
                this.notify();
            }
        }
        arg0.getEventType();
    }

    public static void main(String[] args) throws Exception {
        SerialIO sio = new SerialIO();
        sio.connect("/dev/ttyUSB0");
        while (true) {
            sio.addToPrintQueue(new GCodeMemSave("M114\n", 1, null), true);
            Thread.sleep(1000L);
        }
    }

    public void connect(String port) throws NoSuchPortException {
        CommPortIdentifier cp = CommPortIdentifier.getPortIdentifier((String)port);
        SerialPort serialPort = null;
        try {
            serialPort = (SerialPort)cp.open("GCodeSimulator", 2000);
        }
        catch (PortInUseException e) {
            System.out.println("Port in use.");
        }
        try {
            this.outputStream = serialPort.getOutputStream();
            this.inputStream = serialPort.getInputStream();
        }
        catch (IOException e) {
            System.out.println("Port err." + e);
        }
        try {
            serialPort.setSerialPortParams(115200, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            System.out.println("Port err." + (Object)((Object)e));
        }
        try {
            serialPort.notifyOnDataAvailable(true);
            serialPort.notifyOnBreakInterrupt(true);
            serialPort.notifyOnFramingError(true);
            serialPort.notifyOnOverrunError(true);
            serialPort.notifyOnParityError(true);
            serialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (Exception e) {
            System.out.println("Error setting event notification");
            System.out.println(e.toString());
            System.exit(-1);
        }
        System.out.println("Port successfull opened");
    }

    public class States {
        public boolean connected = false;
        public boolean fan = false;
        public boolean pause = false;
        public boolean debug = false;
        public float extemp = 0.0f;
        public float bedtemp = 0.0f;
        public float distance = 1.0f;
        public boolean printing = false;
        public float[] lastpos = new float[]{0.0f, 0.0f, 0.0f};
        public float lastE = 0.0f;
        public int baud = 115200;

        public float getX() {
            return this.lastpos[0];
        }

        public float getY() {
            return this.lastpos[1];
        }

        public float getZ() {
            return this.lastpos[2];
        }
    }
}

