/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm;

import java.util.Set;
import java.util.TreeSet;

public class SpeedEntry {
    float distance = 0.0f;
    Set<Integer> layers = new TreeSet<Integer>();
    float speed;
    float time = 0.0f;
    Speedtype type = Speedtype.NONE;

    public SpeedEntry(float speed, float time) {
        this.time = time;
        this.speed = speed;
    }

    public SpeedEntry(float speed, float time, int layer) {
        this.time = time;
        this.speed = speed;
        this.addLayers(layer);
    }

    public void addDistance(float distance) {
        this.distance += distance;
    }

    public void addLayers(int layer) {
        this.layers.add(layer);
    }

    public void addTime(float time) {
        this.time += time;
    }

    public float getDistance() {
        return this.distance;
    }

    public Set<Integer> getLayers() {
        return this.layers;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getTime() {
        return this.time;
    }

    public Speedtype getType() {
        return this.type;
    }

    public void setPrint(Speedtype tp) {
        switch (tp) {
            case PRINT: {
                if (this.type == Speedtype.TRAVEL || this.type == Speedtype.BOTH) {
                    this.type = Speedtype.BOTH;
                    break;
                }
                this.type = Speedtype.PRINT;
                break;
            }
            case TRAVEL: {
                if (this.type == Speedtype.PRINT || this.type == Speedtype.BOTH) {
                    this.type = Speedtype.BOTH;
                    break;
                }
                this.type = Speedtype.TRAVEL;
                break;
            }
            default: {
                this.type = tp;
            }
        }
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public static enum Speedtype {
        BOTH,
        NONE,
        PRINT,
        TRAVEL;

    }
}

