/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodes;

import java.io.UnsupportedEncodingException;

public class MemoryEfficientString
implements CharSequence {
    private static final String ENCODING = "ISO-8859-1";
    protected final byte[] data;

    public MemoryEfficientString(String str) {
        try {
            this.data = str.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: ISO-8859-1 not supported!");
        }
    }

    public MemoryEfficientString(byte[] data) {
        this.data = data;
    }

    public MemoryEfficientString(byte[] data1, byte[] data2) {
        this.data = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, this.data, 0, data1.length);
        System.arraycopy(data2, 0, this.data, data1.length, data2.length);
    }

    @Override
    public char charAt(int index) {
        if (index >= this.data.length) {
            throw new StringIndexOutOfBoundsException("Invalid index " + index + " length " + this.length());
        }
        return (char)(this.data[index] & 0xFF);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public MemoryEfficientString subSequence(int start, int end) {
        if (start < 0 || end > this.data.length) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.length());
        }
        byte[] newdata = new byte[end - start];
        System.arraycopy(this.data, start, newdata, 0, end - start);
        return new MemoryEfficientString(newdata);
    }

    public void clear(int idx) {
        int cnt = this.data.length;
        int i = idx;
        while (i < cnt) {
            this.data[i] = 0;
            ++i;
        }
    }

    public MemoryEfficientString subSequence(int start) {
        return this.subSequence(start, this.data.length);
    }

    public byte[] getBytes() {
        return this.data;
    }

    @Override
    public String toString() {
        try {
            return new String(this.data, 0, this.length(), ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: ISO-8859-1 not supported");
        }
    }

    public int indexOf(char ch) {
        if (this.data.length < 1) {
            return -1;
        }
        int i = 0;
        while (i < this.data.length - 1) {
            if (this.data[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String toString(byte[] data) {
        try {
            return new String(data, 0, data.length, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: ISO-8859-1 not supported");
        }
    }
}

