/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodesim;

import de.dietzm.Model;
import de.dietzm.gcodesim.AWTGraphicRenderer;
import de.dietzm.gcodesim.GcodePainter;
import de.dietzm.gcodesim.NetworkPrinter;
import de.dietzm.print.ConsoleIf;
import de.dietzm.print.Dummy;
import de.dietzm.print.ReceiveBuffer;
import de.dietzm.print.SerialPrinter;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class GcodeSimulator
extends Frame
implements ActionListener {
    public static final String VERSION = "v1.18";
    GcodePainter gp;
    AWTGraphicRenderer awt;
    boolean showdetails = true;
    int bedsizeX = 200;
    int bedsizeY = 200;
    static String networkip = "192.168.0.50";
    static String lastfilepath = System.getProperty("user.dir");

    public GcodeSimulator() {
        this.setTitle("GCode Print Simulator v1.18");
        this.setBackground(Color.black);
    }

    public void init(String filename, InputStream in) throws IOException {
        this.awt = new AWTGraphicRenderer(this.bedsizeX, this.bedsizeY, this);
        float fac = (this.awt.getHeight() - (55 + this.awt.getHeight() / 12)) / this.bedsizeY;
        this.gp = new GcodePainter(this.awt);
        this.gp.setZoom(fac);
        this.updateSize(this.showdetails);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icon.png")));
        this.setMenuBar(this.getMyMenubar());
        this.setVisible(true);
        this.setBackground(Color.black);
        this.addListeners();
        this.gp.start(filename, in, null);
    }

    private void addMenuItem(Menu parent, String name, String key, int keycode) {
        MenuItem it = new MenuItem(name);
        it.addActionListener(this);
        it.setActionCommand(key);
        MenuShortcut ms = new MenuShortcut(keycode);
        it.setShortcut(ms);
        parent.add(it);
    }

    protected MenuBar getMyMenubar() {
        MenuBar ml = new MenuBar();
        Menu datei = new Menu("File");
        this.addMenuItem(datei, "Load File", "f", 70);
        this.addMenuItem(datei, "Network Send", "x", 88);
        this.addMenuItem(datei, "Exit", "q", 81);
        ml.add(datei);
        Menu control = new Menu("Control");
        this.addMenuItem(control, "Pause", "p", 80);
        control.addSeparator();
        this.addMenuItem(control, "Increase Speed", "+", 521);
        this.addMenuItem(control, "Increase Speed by 10", "/", 47);
        this.addMenuItem(control, "Decrease Speed", "-", 45);
        this.addMenuItem(control, "Decrease Speed by 10", "*", 151);
        control.addSeparator();
        this.addMenuItem(control, "Next Layer", "n", 78);
        this.addMenuItem(control, "Previous Layer", "b", 66);
        control.addSeparator();
        this.addMenuItem(control, "Step Forward", " ", 32);
        this.addMenuItem(control, "Step Backward", "\b", 8);
        control.addSeparator();
        this.addMenuItem(control, "Restart", "r", 82);
        Menu view = new Menu("View");
        this.addMenuItem(view, "Zoom In", "i", 73);
        this.addMenuItem(view, "Zoom Out", "o", 79);
        view.addSeparator();
        this.addMenuItem(view, "Show/Hide Details", "m", 77);
        this.addMenuItem(view, "Toggle Detail type", "t", 84);
        Menu about = new Menu("About");
        this.addMenuItem(about, "About/Help", "h", 72);
        Menu edit = new Menu("Modify (Experimental)");
        edit.add("Experimental Edit Mode");
        edit.addSeparator();
        this.addMenuItem(edit, "Speedup Layer by 10%", "w", 87);
        this.addMenuItem(edit, "Slowdown Layer by 10%", "e", 69);
        this.addMenuItem(edit, "Increase extrusion by 10%", "z", 90);
        this.addMenuItem(edit, "Decrease extrusion by 10%", "u", 85);
        this.addMenuItem(edit, "Delete layer", "g", 71);
        this.addMenuItem(edit, "Save Modifications", "a", 65);
        ml.add(control);
        ml.add(view);
        ml.add(about);
        return ml;
    }

    public GcodeSimulator getFrame() {
        return this;
    }

    public static void main(String[] args) throws Exception {
        String filename;
        GcodeSimulator gs = new GcodeSimulator();
        InputStream in = null;
        GcodeSimulator.readConfig();
        if (args.length < 1 || !new File(args[0]).exists()) {
            filename = "/gcodesim.gcode";
            in = gs.getClass().getResourceAsStream(filename);
        } else {
            filename = args[0];
        }
        gs.init(filename, in);
        gs.requestFocus();
    }

    public static void readConfig() {
        String homedir = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        File config = new File(String.valueOf(homedir) + sep + ".gcodesim");
        if (config.exists()) {
            try {
                Properties prop = new Properties();
                prop.load(new FileInputStream(config));
                lastfilepath = prop.getProperty("lastfilepath", System.getProperty("user.dir"));
                networkip = prop.getProperty("networkip", "192.168.0.50");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Config file does not exist:" + config);
        }
    }

    public static void storeConfig() {
        String homedir = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        File config = new File(String.valueOf(homedir) + sep + ".gcodesim");
        try {
            Properties prop = new Properties();
            prop.setProperty("lastfilepath", lastfilepath);
            prop.setProperty("networkip", networkip);
            prop.store(new FileOutputStream(config), "Gcode Simulator Config");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        char a = arg0.getActionCommand().charAt(0);
        this.getKeyListeners()[0].keyTyped(new KeyEvent(this, 0, 0L, 0, a, a));
    }

    public void showNetworkIPDialog() {
        final Dialog in = new Dialog(this, "Send to GCode Simulator for Android", true);
        in.setLayout(new FlowLayout());
        in.setBackground(Color.lightGray);
        final TextField tf2 = new TextField(15);
        final Label status = new Label("                                                    ");
        tf2.setText(networkip);
        Button btn1 = new Button("Ok");
        in.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                in.setVisible(false);
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                in.setVisible(false);
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }
        });
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NetworkPrinter netp = new NetworkPrinter();
                    status.setText("Sending file ... please wait");
                    in.repaint();
                    networkip = tf2.getText();
                    GcodeSimulator.storeConfig();
                    netp.sendToReceiver(networkip, GcodeSimulator.this.gp.model);
                    status.setText("Sending file ... done");
                    in.repaint();
                    in.setVisible(false);
                }
                catch (UnknownHostException uh) {
                    status.setText("Invalid IP address:" + uh.getMessage());
                    in.repaint();
                }
                catch (ConnectException ce) {
                    status.setText("Connect error:" + ce.getMessage());
                    in.repaint();
                }
                catch (IOException e2) {
                    status.setText("Error:" + e2.getMessage());
                    in.repaint();
                }
            }
        };
        btn1.addActionListener(action);
        tf2.addActionListener(action);
        in.add(new Label("Enter IP Address"));
        in.add(tf2);
        in.add(btn1);
        in.add(status);
        in.setSize(330, 120);
        in.setVisible(true);
    }

    static String openFileBrowser(Frame gs) {
        String filename = null;
        final FileDialog fd = new FileDialog(gs, "Choose a gcode file");
        final Thread gpt = Thread.currentThread();
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (fd.isVisible()) {
                    gpt.interrupt();
                    fd.setVisible(false);
                }
            }
        }, 100000L);
        if (lastfilepath != null) {
            fd.setDirectory(lastfilepath);
        } else {
            fd.setDirectory(System.getProperty("user.dir"));
        }
        fd.setModal(true);
        if (!System.getProperty("os.name").startsWith("Mac OS X")) {
            fd.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    if (arg1.toLowerCase().endsWith(".gcode")) {
                        return true;
                    }
                    return arg1.toLowerCase().endsWith(".gc");
                }
            });
        }
        fd.requestFocus();
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        filename = String.valueOf(fd.getDirectory()) + fd.getFile();
        t.cancel();
        lastfilepath = fd.getDirectory();
        GcodeSimulator.storeConfig();
        return filename;
    }

    private void updateSize(boolean details) {
        if ((this.getExtendedState() & 6) == 0) {
            int[] sz = this.gp.getSize(details);
            this.setSize(sz[0], sz[1]);
        }
    }

    private void addListeners() {
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent arg0) {
                int mwrot = arg0.getWheelRotation();
                if (arg0.isControlDown() || arg0.isAltDown()) {
                    if (GcodeSimulator.this.gp.getZoom() > 1.0f && mwrot < 0) {
                        GcodeSimulator.this.gp.setZoom(GcodeSimulator.this.gp.getZoom() + (float)mwrot / 10.0f);
                    }
                    if (GcodeSimulator.this.gp.getZoom() < 8.0f && mwrot > 0) {
                        GcodeSimulator.this.gp.setZoom(GcodeSimulator.this.gp.getZoom() + (float)mwrot / 10.0f);
                    }
                    GcodeSimulator.this.updateSize(GcodeSimulator.this.showdetails);
                } else if ((float)arg0.getPoint().x < (float)GcodeSimulator.this.bedsizeX * GcodeSimulator.this.gp.getZoom() + 20.0f) {
                    if (mwrot > 0) {
                        GcodeSimulator.this.gp.toggleSpeed(false);
                    } else {
                        GcodeSimulator.this.gp.toggleSpeed(true);
                    }
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 3) {
                    if (arg0.isAltDown() || arg0.isControlDown()) {
                        GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.OPENFILE);
                    } else {
                        GcodeSimulator.this.showdetails = !GcodeSimulator.this.showdetails;
                        GcodeSimulator.this.updateSize(GcodeSimulator.this.showdetails);
                    }
                } else if (arg0.getButton() == 2) {
                    GcodeSimulator.this.gp.showHelp();
                } else {
                    int speedboxpos = (int)(((float)GcodeSimulator.this.bedsizeX * GcodeSimulator.this.gp.getZoom() + 20.0f) / 100.0f * 82.0f) + 6;
                    int speedboxsize = (int)(((float)GcodeSimulator.this.bedsizeX * GcodeSimulator.this.gp.getZoom() + 20.0f) / 100.0f) * 12;
                    int mousex = arg0.getPoint().x;
                    if (mousex >= speedboxpos && mousex <= speedboxpos + speedboxsize && (float)arg0.getPoint().y > (float)GcodeSimulator.this.bedsizeY * GcodeSimulator.this.gp.getZoom() + 55.0f) {
                        GcodeSimulator.this.gp.togglePause();
                    } else if ((float)arg0.getPoint().x > (float)GcodeSimulator.this.bedsizeX * GcodeSimulator.this.gp.getZoom() + 20.0f) {
                        GcodeSimulator.this.gp.toggleType();
                    } else if (arg0.isAltDown() || arg0.isControlDown()) {
                        GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.PREVIOUSLAYER);
                    } else {
                        GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.NEXTLAYER);
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                float size = GcodeSimulator.this.getHeight();
                float currsize = GcodeSimulator.this.gp.getSize(false)[1];
                if (currsize != size) {
                    float fac = (size - (55.0f + size / 12.0f)) / (float)GcodeSimulator.this.bedsizeY;
                    GcodeSimulator.this.gp.setZoom(fac);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (arg0.getKeyChar() == '+') {
                    GcodeSimulator.this.gp.toggleSpeed(true);
                } else if (arg0.getKeyChar() == '-') {
                    GcodeSimulator.this.gp.toggleSpeed(false);
                } else if (arg0.getKeyChar() == '/') {
                    GcodeSimulator.this.gp.toggleSpeed(true, 10);
                } else if (arg0.getKeyChar() == '*') {
                    GcodeSimulator.this.gp.toggleSpeed(false, 10);
                } else if (arg0.getKeyChar() == ' ') {
                    GcodeSimulator.this.gp.doStep(true);
                } else if (arg0.getKeyChar() == '\b') {
                    GcodeSimulator.this.gp.doStep(false);
                } else if (arg0.getKeyChar() == 'n') {
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.NEXTLAYER);
                } else if (arg0.getKeyChar() == 'b') {
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.PREVIOUSLAYER);
                } else if (arg0.getKeyChar() == 'd') {
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.DEBUG);
                } else if (arg0.getKeyChar() == 'm') {
                    GcodeSimulator.this.showdetails = !GcodeSimulator.this.showdetails;
                    GcodeSimulator.this.updateSize(GcodeSimulator.this.showdetails);
                } else if (arg0.getKeyChar() == 't') {
                    GcodeSimulator.this.gp.toggleType();
                } else if (arg0.getKeyChar() == 'r') {
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.RESTART);
                } else if (arg0.getKeyChar() == 'i') {
                    if (GcodeSimulator.this.gp.getZoom() < 8.0f) {
                        GcodeSimulator.this.gp.setZoom(GcodeSimulator.this.gp.getZoom() + 0.5f);
                    }
                    GcodeSimulator.this.updateSize(GcodeSimulator.this.showdetails);
                } else if (arg0.getKeyChar() == 'o') {
                    if (GcodeSimulator.this.gp.getZoom() > 1.0f) {
                        GcodeSimulator.this.gp.setZoom(GcodeSimulator.this.gp.getZoom() - 0.5f);
                    }
                    GcodeSimulator.this.updateSize(GcodeSimulator.this.showdetails);
                } else if (arg0.getKeyChar() == 'q') {
                    System.exit(0);
                } else if (arg0.getKeyChar() == 'f') {
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.OPENFILE);
                } else if (arg0.getKeyChar() == 'p') {
                    GcodeSimulator.this.gp.togglePause();
                } else if (arg0.getKeyChar() == 's') {
                    try {
                        ConsoleIf cons = new ConsoleIf(){

                            @Override
                            public void updateState(CharSequence statemsg, CharSequence detail, int perc) {
                            }

                            @Override
                            public void setWakeLock(boolean active) {
                            }

                            @Override
                            public void setTemp(CharSequence temp) {
                            }

                            @Override
                            public void setPrinting(boolean printing) {
                            }

                            @Override
                            public void log(String tag, String value, ReceiveBuffer buf) {
                            }

                            @Override
                            public void log(String tag, String value) {
                            }

                            @Override
                            public boolean hasWakeLock() {
                                return false;
                            }

                            @Override
                            public void clearConsole() {
                            }

                            @Override
                            public int chooseDialog(String[] items, String[] values, int type) {
                                return 0;
                            }

                            @Override
                            public void appendTextNoCR(CharSequence ... txt) {
                            }

                            @Override
                            public void appendText(CharSequence ... txt) {
                                CharSequence[] charSequenceArray = txt;
                                int n = txt.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CharSequence n3 = charSequenceArray[n2];
                                    System.out.println(n3);
                                    ++n2;
                                }
                            }
                        };
                        SerialPrinter sio = new SerialPrinter(cons);
                        GcodeSimulator.this.gp.setPrintercon(sio);
                        sio.connect(new Dummy(sio, cons), 115200);
                    }
                    catch (NoClassDefFoundError er) {
                        System.out.println("Opening COM Port FAILED ! RXTX Jar Missing.  " + er);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Opening COM Port FAILED ! " + e);
                    }
                    catch (UnsatisfiedLinkError ule) {
                        System.out.println("Opening COM Port FAILED ! RXTX Jar Missing.  " + ule);
                    }
                    GcodeSimulator.this.gp.togglePrint();
                } else if (arg0.getKeyChar() == 'x') {
                    GcodeSimulator.this.showNetworkIPDialog();
                } else if (arg0.getKeyChar() == 'h') {
                    GcodeSimulator.this.gp.showHelp();
                } else if (arg0.getKeyChar() == 'g') {
                    Model.deleteLayer(Collections.singleton(GcodeSimulator.this.gp.getCurrentLayer()));
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.REANALYSE);
                } else if (arg0.getKeyChar() == 'w') {
                    Model.changeSpeed(Collections.singleton(GcodeSimulator.this.gp.getCurrentLayer()), 10);
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.REANALYSE);
                } else if (arg0.getKeyChar() == 'e') {
                    Model.changeSpeed(Collections.singleton(GcodeSimulator.this.gp.getCurrentLayer()), -10);
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.REANALYSE);
                } else if (arg0.getKeyChar() == 'z') {
                    Model.changeExtrusion(Collections.singleton(GcodeSimulator.this.gp.getCurrentLayer()), 10);
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.REANALYSE);
                } else if (arg0.getKeyChar() == 'u') {
                    Model.changeExtrusion(Collections.singleton(GcodeSimulator.this.gp.getCurrentLayer()), -10);
                    GcodeSimulator.this.gp.setCmd(GcodePainter.Commands.REANALYSE);
                } else if (arg0.getKeyChar() == 'a') {
                    try {
                        GcodeSimulator.this.gp.model.saveModel(String.valueOf(GcodeSimulator.this.gp.model.getFilename()) + "-new");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (arg0.getKeyCode() != 0) {
                    GcodeSimulator.this.gp.showHelp();
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        this.awt.drawImage(g);
        super.paint(g);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

