/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodesim;

import de.dietzm.Model;
import de.dietzm.gcodes.GCode;
import de.dietzm.gcodesim.PrintReceiveListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class NetworkPrinter
implements Runnable {
    ServerSocket sock = null;
    PrintReceiveListener gp = null;
    Thread th;
    public static final int PORT = 53232;

    public void startPrintReceiver(PrintReceiveListener gp) throws IOException {
        this.gp = gp;
        this.sock = new ServerSocket(53232);
        this.th = new Thread(this);
        this.th.start();
    }

    public void sendToReceiver(String ip, Model mod) throws IOException {
        Socket cs = new Socket(ip, 53232);
        OutputStream out = cs.getOutputStream();
        BufferedOutputStream bufout = new BufferedOutputStream(out, 32768);
        byte[] transBuf = new byte[1024];
        int len = 0;
        ArrayList<GCode> gcodes = mod.getGcodes();
        for (GCode gCode : gcodes) {
            len = gCode.getCodeline(transBuf);
            bufout.write(transBuf, 0, len);
        }
        bufout.flush();
        cs.close();
    }

    private Socket waitForData() throws Exception {
        Socket s = this.sock.accept();
        return s;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                Socket sin = this.waitForData();
                String filename = String.valueOf(sin.getInetAddress().getHostAddress()) + "_" + new SimpleDateFormat("yyMMdd_HHmmss").format(new Date()) + ".gcode";
                this.gp.printreceived(filename, sin.getInputStream());
                sin.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopPrintReceiver() {
        try {
            this.th.interrupt();
            this.sock.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

