/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodes;

import de.dietzm.Constants;
import de.dietzm.Position;
import de.dietzm.gcodes.MemoryEfficientString;
import java.io.UnsupportedEncodingException;

public abstract class GCode {
    protected byte[] data;
    protected short gcode;
    protected int lineindex;

    public GCode(String line, int linenr, Constants.GCDEF code) {
        this.updateDataArray(line);
        this.lineindex = linenr;
        this.gcode = code.getId();
    }

    public String getComment() {
        return MemoryEfficientString.toString(this.data);
    }

    public boolean isComment() {
        return Constants.GCDEF.COMMENT.equals(this.gcode);
    }

    public void setLineindex(int lineindex) {
        this.lineindex = lineindex;
    }

    protected String stripComment(String clv) {
        int idx = clv.indexOf(59);
        if (idx != -1) {
            clv = clv.substring(0, idx);
        } else {
            idx = clv.indexOf("(<");
            if (idx != -1) {
                clv = clv.substring(0, idx);
            } else {
                idx = clv.indexOf(40);
                if (idx != -1) {
                    clv = clv.substring(0, idx);
                }
            }
        }
        return clv.trim();
    }

    public boolean isPrintable() {
        return !Constants.GCDEF.COMMENT.equals(this.gcode);
    }

    public MemoryEfficientString getCodeline() {
        if (this.getGcode() == Constants.GCDEF.COMMENT || this.getGcode() == Constants.GCDEF.UNKNOWN) {
            return new MemoryEfficientString(this.data, Constants.newline);
        }
        byte[] gc1 = this.getGcode().getBytes();
        int len = gc1.length + 2 + this.data.length;
        byte[] newdata = new byte[len];
        System.arraycopy(gc1, 0, newdata, 0, gc1.length);
        System.arraycopy(this.data, 0, newdata, gc1.length + 1, this.data.length);
        newdata[gc1.length] = 32;
        newdata[len - 1] = 10;
        return new MemoryEfficientString(newdata);
    }

    public int getCodeline(byte[] buffer) {
        if (this.getGcode() == Constants.GCDEF.COMMENT || this.getGcode() == Constants.GCDEF.UNKNOWN) {
            System.arraycopy(this.data, 0, buffer, 0, this.data.length);
            buffer[this.data.length] = 10;
            return this.data.length + 1;
        }
        byte[] gc1 = this.getGcode().getBytes();
        int len = gc1.length + 2 + this.data.length;
        if (buffer.length < len) {
            System.err.println("GCode.getCodeline: Buffer to small");
            return -1;
        }
        System.arraycopy(gc1, 0, buffer, 0, gc1.length);
        System.arraycopy(this.data, 0, buffer, gc1.length + 1, this.data.length);
        buffer[gc1.length] = 32;
        buffer[len - 1] = 10;
        return len;
    }

    protected void updateDataArray(String line) {
        try {
            this.data = line.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: ISO-8859-1 not supported!");
        }
    }

    public int getLineindex() {
        return this.lineindex;
    }

    public Constants.GCDEF getGcode() {
        return Constants.GCDEF.getGCDEF(this.gcode);
    }

    protected MemoryEfficientString subSequence(int start, int end) {
        if (start < 0 || end > this.data.length) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.data.length);
        }
        byte[] newdata = new byte[end - start];
        System.arraycopy(this.data, start, newdata, 0, end - start);
        return new MemoryEfficientString(newdata);
    }

    protected String toStringRaw() {
        try {
            return new String(this.data, 0, this.data.length, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: ISO-8859-1 not supported");
        }
    }

    public boolean isBuffered() {
        return Constants.GCDEF.G0.equals(this.gcode) || Constants.GCDEF.G1.equals(this.gcode) || Constants.GCDEF.G2.equals(this.gcode) || Constants.GCDEF.M106.equals(this.gcode) || Constants.GCDEF.M107.equals(this.gcode) || Constants.GCDEF.G29.equals(this.gcode) || Constants.GCDEF.G30.equals(this.gcode) || Constants.GCDEF.G31.equals(this.gcode) || Constants.GCDEF.G32.equals(this.gcode);
    }

    public boolean isLongRunning() {
        return Constants.GCDEF.M190.equals(this.gcode) || Constants.GCDEF.M109.equals(this.gcode) || Constants.GCDEF.G28.equals(this.gcode) || Constants.GCDEF.M29.equals(this.gcode);
    }

    protected abstract void setUnit(String var1);

    public abstract boolean isInitialized(int var1);

    public abstract void setInitialized(short var1, float var2);

    public abstract String toCSV();

    public String toString() {
        return this.getCodeline().toString();
    }

    public abstract float getExtrusionSpeed();

    public abstract float getTimeAccel();

    public abstract void setTimeAccel(float var1);

    public abstract void setTime(float var1);

    public abstract void setExtrusion(float var1);

    public abstract void setDistance(float var1);

    public abstract void setCurrentPosition(Position var1);

    public abstract boolean isExtruding();

    public abstract boolean isExtrudeOrRetract();

    public abstract float getZ();

    public abstract float getY();

    public abstract float getR();

    public abstract float getKz();

    public abstract float getJy();

    public abstract float getIx();

    public abstract float getX();

    public abstract String getUnit();

    public abstract float getTime();

    public abstract float getSpeed();

    public abstract Position getPosition(Position var1);

    public abstract float getS_Fan();

    public abstract float getF();

    public abstract float getExtrusion();

    public abstract float getS_Ext();

    public abstract float getE();

    public abstract float getDistance();

    public abstract Position getCurrentPosition(Position var1);

    public abstract float getS_Bed();

    public abstract float getBedtemp();

    public abstract float getExtemp();

    public abstract void setFanspeed(float var1);

    public abstract short getFanspeed();
}

