/*
 * Decompiled with CFR 0.152.
 */
package de.dietzm.gcodesim;

import de.dietzm.SerialIO;
import de.dietzm.gcodesim.GcodeSimulator;
import de.dietzm.gcodesim.GraphicRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

public class AWTGraphicRenderer
implements GraphicRenderer {
    Color[] backcol = new Color[]{Color.BLACK, new Color(0, 90, 120), Color.red};
    final Color[] colors = new Color[]{Color.red, Color.cyan, Color.yellow, Color.magenta, Color.green, Color.orange, Color.pink, Color.white, Color.darkGray};
    Frame frame;
    Graphics2D g = null;
    private final GraphicsConfiguration gfxConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    BufferedImage offimg;
    BufferedImage offimg2;
    int[] pos = new int[5];
    SerialIO sio = null;
    String titletxt = null;
    long titletime = 0L;
    private BasicStroke[] stroke = new BasicStroke[]{new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{1.0f, 2.0f}, 0.0f), new BasicStroke(3.5f, 0, 1), new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{1.0f, 6.0f}, 0.0f)};

    public AWTGraphicRenderer(int bedsizeX, int bedsizeY, Frame frame) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int wmax = (int)Math.min(d.getWidth(), 1920.0);
        int hmax = (int)Math.min(d.getHeight(), 1200.0);
        this.offimg = this.gfxConf.createCompatibleImage(wmax, hmax);
        this.offimg2 = this.gfxConf.createCompatibleImage(wmax, hmax);
        this.g = (Graphics2D)this.offimg.getGraphics();
        this.g.setBackground(Color.black);
        this.g.setFont(Font.decode("SansSerif"));
        this.frame = frame;
    }

    @Override
    public String browseFileDialog() {
        String var = GcodeSimulator.openFileBrowser(this.frame);
        this.frame.requestFocus();
        return var;
    }

    @Override
    public void clearrect(float x, float y, float w, float h, int colitem) {
        this.g.setBackground(this.backcol[colitem]);
        this.g.clearRect((int)x, (int)y, (int)w, (int)h);
    }

    @Override
    public void faintRect(float x, float y, float w, float h) {
    }

    private void cloneImage() {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int theta, int delta) {
        this.g.drawArc(x, y, width, height, theta, delta);
    }

    @Override
    public int getColorNr() {
        return this.colors.length;
    }

    public synchronized void drawImage(Graphics gp1) {
        Graphics2D gp = (Graphics2D)this.offimg2.getGraphics();
        gp.drawImage((Image)this.offimg, 6, 55, this.frame);
        if (this.getPos()[0] != 0) {
            gp.setColor(this.g.getColor());
            gp.fillOval(this.getPos()[0] + 4, this.getPos()[1] + 53, 4, 4);
            gp.setColor(Color.white);
            gp.drawOval(this.getPos()[0] - 2, this.getPos()[1] + 47, 16, 16);
            gp.drawOval(this.getPos()[0] + 0, this.getPos()[1] + 49, 12, 12);
            gp.drawOval(this.getPos()[0] + 2, this.getPos()[1] + 51, 8, 8);
            this.paintExtruder(gp, this.getPos()[3], this.getPos()[2], this.getPos()[4]);
        }
        if (this.titletxt != null && System.currentTimeMillis() - this.titletime > 1500L) {
            if (System.currentTimeMillis() - this.titletime > 3000L) {
                this.titletime = System.currentTimeMillis();
            }
            gp.setColor(Color.GREEN);
            gp.setFont(gp.getFont().deriveFont(26.0f));
            gp.drawString(this.titletxt, 20, 90);
        }
        gp1.drawImage(this.offimg2, 0, 0, this.frame);
    }

    private void paintExtruder(Graphics2D gp, int pos, int poss, int zpos) {
        gp.setColor(Color.white);
        gp.fillRect(pos + 2, zpos + 51 - 23, 15, 20);
        gp.drawLine(pos + 2, zpos + 51 - 3, pos + 2 + 7, zpos + 51 + 2);
        gp.drawLine(pos + 2 + 14, zpos + 51 - 3, pos + 2 + 7, zpos + 51 + 2);
        gp.fillRect(pos + 2 - 13, zpos + 51 - 45, 46, 28);
        gp.setColor(Color.lightGray);
        gp.fillOval(pos + 2 + 2, zpos + 51 - 53, 35, 35);
        gp.fillOval(pos - 6, zpos + 51 - 41, 11, 11);
        gp.setColor(Color.white);
        gp.fillOval(pos + 2 + 14, zpos + 51 - 41, 11, 11);
        gp.fillOval(pos - 2, zpos + 51 - 37, 3, 3);
        gp.fillOval(poss + 2, zpos + 52, 3, 3);
        gp.setColor(this.g.getColor());
        gp.drawArc(pos - 185, zpos + 51 - 130, 190, 190, 0, 40);
    }

    @Override
    public void drawline(float x, float y, float x1, float y1) {
        this.g.draw(new Line2D.Float(x, y, x1, y1));
    }

    @Override
    public void drawrect(float x, float y, float w, float h) {
        this.g.drawRect((int)x, (int)y, (int)w, (int)h);
    }

    @Override
    public void drawtext(CharSequence text, float x, float y) {
        this.g.drawString(text.toString(), x, y);
    }

    @Override
    public void drawtext(CharSequence text, float x, float y, float w) {
        String txt = text.toString();
        int wide = this.g.getFontMetrics().stringWidth(txt);
        float center = (w - (float)wide) / 2.0f;
        this.g.drawString(txt, x + center, y);
    }

    @Override
    public void fillrect(float x, float y, float w, float h) {
        this.g.fillRect((int)x, (int)y, (int)w, (int)h);
    }

    @Override
    public int getHeight() {
        return this.offimg.getHeight();
    }

    public synchronized int[] getPos() {
        return this.pos;
    }

    @Override
    public int getWidth() {
        return this.offimg.getWidth();
    }

    @Override
    public synchronized void repaint() {
        this.frame.repaint();
    }

    @Override
    public void setColor(int idx) {
        this.g.setColor(this.colors[idx]);
    }

    @Override
    public void setFontSize(float font) {
        this.g.setFont(this.g.getFont().deriveFont(font));
    }

    @Override
    public synchronized void setPos(int x, int y) {
        this.pos[0] = x;
        this.pos[1] = y;
    }

    @Override
    public void setPos(int x1, int x2, int z) {
        this.pos[2] = x1;
        this.pos[3] = x2;
        this.pos[4] = z;
    }

    @Override
    public void setStroke(int idx) {
        this.g.setStroke(this.stroke[idx]);
    }

    @Override
    public void setTitle(String txt) {
        this.titletxt = txt;
    }
}

